% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProtectTable1.R
\encoding{UTF8}
\name{ProtectTable1}
\alias{ProtectTable1}
\title{Easy input interface to sdcTable}
\usage{
ProtectTable1(
  data,
  dimVarInd = 1:NCOL(data),
  freqVarInd = NULL,
  protectZeros = TRUE,
  maxN = 3,
  method = "SIMPLEHEURISTIC",
  findLinked = TRUE,
  total = "Total",
  addName = FALSE,
  sep = ".",
  removeZeros = FALSE,
  dimList = NULL,
  groupVarInd = NULL,
  ind1 = NULL,
  ind2 = NULL,
  dimDataReturn = FALSE,
  IncProgress = IncDefault,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{Matrix or data frame}

\item{dimVarInd}{Column-indices of the main dimensional variables and additional aggregating variables.}

\item{freqVarInd}{Column-indices of a variable holding counts or NULL in the case of micro data.}

\item{protectZeros}{When TRUE empty cells (count=0) is considered sensitive (i.e. same as allowZeros in primarySuppression).}

\item{maxN}{All cells having counts <= maxN are set as primary suppressed.}

\item{method}{Parameter "method" in protectTable or protect_linked_tables.
Alternatively a list defining parameters for running tau-argus (see \code{\link{ProtectTable}}).}

\item{findLinked}{When TRUE, the function may find two linked tables and run protect_linked_tables.}

\item{total}{String used to name totals.}

\item{addName}{When TRUE the variable name is added to the level names, except for variables with most levels.}

\item{sep}{A character string to separate when addName apply.}

\item{removeZeros}{When TRUE, rows with zero count will be removed from the data.}

\item{dimList}{See \code{\link{ProtectTable}}.}

\item{groupVarInd}{Possible manual specification if list defining the hierarchical variable groups}

\item{ind1}{Coding of table 1 as indices referring to elements of groupVarInd}

\item{ind2}{Coding of table 2 as indices referring to elements of groupVarInd}

\item{dimDataReturn}{When TRUE a data frame containing the dimVarInd variables is retuned}

\item{IncProgress}{A function to report progress (incProgress in Shiny).}

\item{verbose}{Parameter sent to protectTable, protect_linked_tables or runArgusBatchFile.}

\item{...}{Further parameters sent to protectTable, protect_linked_tables or createArgusInput.}
}
\value{
Output is a list of three elements.

        \strong{table1} consists of the following elements:
        \item{secondary}{Output from \code{\link[sdcTable]{protectTable}} or first element of output from \code{\link[sdcTable]{protect_linked_tables}} 
        or output from \code{\link[sdcTable]{runArgusBatchFile}}.}
        \item{primary}{Output from \code{\link[sdcTable]{primarySuppression}}.}
        \item{problem}{Output from \code{\link[sdcTable]{makeProblem}}.}
        \item{dimList}{Generated input to makeProblem.}
        \item{ind}{Indices referring to elements of groupVarInd in the output element common.}

        \strong{table2} consists of elements of the same type as table1 in cases of two linked tables. Otherwise  table2 is NULL.

        \strong{common} consists of the following elements:
        \item{commonCells}{Input to protect_linked_tables.}
        \item{groupVarInd}{List defining the hierarchical variable groups}
        \item{info}{A table summarizing the tables using variable names}
        \item{nLevels}{The number of levels of each variable (only when groupVarInd input is NULL)}
        \item{dimData}{Data frame containing the dimVarInd variables when dimDataReturn=TRUE. Otherwise NULL.}
}
\description{
protectTable or protect_linked_tables is run with a data set at the only required input.
}
\details{
One or two tables are identified automatically and subjected to cell suppression methods in package sdcTable.
         The tables can alternatively be specified manually by groupVarInd, ind1 and ind2 (see \code{\link[SSBtools]{FindTableGroup}}).
}
\examples{
\dontrun{
z2 <- EasyData("z2")
a <- ProtectTable1(z2, c(1, 3, 4), 5)
head(as.data.frame(sdcTable::getInfo(a[[1]][[1]], type = "finalData"))) # The table (not linked)

z3 <- EasyData("z3")
b <- ProtectTable1(z3, 1:6, 7)
head(as.data.frame(sdcTable::getInfo(b[[1]][[1]], type = "finalData"))) # First table
head(as.data.frame(sdcTable::getInfo(b[[2]][[1]], type = "finalData"))) # Second table
}
}
\seealso{
\code{\link{ProtectTable}}, 
        \code{\link[SSBtools]{HierarchicalGroups}}, \code{\link[SSBtools]{FactorLevCorr}},
        \code{\link[SSBtools]{FindDimLists}}, \code{\link[SSBtools]{FindCommonCells}}
}
