% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFormat.r
\name{checkFormat}
\alias{checkFormat}
\title{Check and Adjust SPSS Format}
\usage{
checkFormat(GADSdat, type = "SPSS", changeFormat = TRUE)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{type}{If \code{type='other'}, the function \code{nchar} will be used to determine character lengths and decimals are not rounded to 16 decimal places. With \code{type='SPSS'} additional width for character variables will be added in order to let SPSS read in lengthy characters correctly and .}

\item{changeFormat}{If \code{changeFormat=TRUE} the \code{GADSdat} meta data will be updated otherwise only information will be reported.}
}
\value{
Returns a \code{GADSdat} object.
}
\description{
Function to check if SPSS format statements are specified correctly in a \code{GADSdat} object.
}
\details{
The function compares SPSS format statements \code{"format"} and actual character length and
decimal places of all variables in a \code{GADSdat} object and its
meta data information. Mismatches are reported and can be automatically adjusted.
}
\examples{
# Change example meta information (create a value label with incorrect missing code)
pisa2 <- checkFormat(pisa)


}
