% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGADS.R
\name{getGADS}
\alias{getGADS}
\title{Get data from GADS data base.}
\usage{
getGADS(vSelect = NULL, filePath)
}
\arguments{
\item{vSelect}{Character vector of variable names.}

\item{filePath}{Path of the existing \code{eatGADS} data base file.}
}
\value{
Returns a \code{GADSdat} object.
}
\description{
Extracts variables from a GADS data base. Only the specified variables are extracted. Note that this selection determines the format of
the \code{data.frame} that is extracted.
}
\details{
See \code{\link[eatDB]{createDB}} and \code{\link[eatDB]{dbPull}} for further explanation of the query and merging processes.
}
\examples{
# Use data base within package
db_path <- system.file("extdata", "pisa.db", package = "eatGADS")
pisa_gads <- getGADS(db_path, vSelect = c("schtype", "sameteach"))

}
