% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eb.R
\name{ebci}
\alias{ebci}
\title{Compute empirical Bayes confidence intervals by shrinking toward regression}
\usage{
ebci(
  formula,
  data,
  se,
  weights = NULL,
  alpha = 0.1,
  kappa = NULL,
  wopt = FALSE,
  fs_correction = "PMT"
)
}
\arguments{
\item{formula}{object of class \code{"formula"} (or one that can be coerced
to that class) of the form \code{Y ~ predictors}, where \code{Y} is a
preliminary unbiased estimator, and \code{predictors} are predictors
\eqn{X} that guide the direction of shrinkage. For shrinking toward the
grand mean, use \code{Y ~ 1}, and for shrinking toward \code{0} use
\code{Y ~ 0}}

\item{data}{optional data frame, list or environment (or object coercible by
\code{as.data.frame} to a data frame) containing the preliminary
estimator \code{Y} and the predictors. If not found in \code{data}, these
variables are taken from \code{environment(formula)}, typically the
environment from which the function is called.}

\item{se}{Standard errors \eqn{\sigma}{sigma} associated with the preliminary
estimates \code{Y}}

\item{weights}{An optional vector of weights to be used in the fitting
process in computing \eqn{\delta}{delta}, \eqn{\mu_2}{mu_2} and
\eqn{\kappa}{kappa}. Should be \code{NULL} or a numeric vector.}

\item{alpha}{Determines confidence level, \eqn{1-\alpha}{1-alpha}.}

\item{kappa}{If non-\code{NULL}, use pre-specified value for the kurtosis
\eqn{\kappa}{kappe} of \eqn{\theta-X'\delta}{theta-X*delta} (such as
\code{Inf}), instead of computing it.}

\item{wopt}{If \code{TRUE}, also compute length-optimal robust EBCIs. These
are robust EBCIs centered at estimates with the shrinkage factor
\eqn{w_i}{w_i} chosen to minimize the length of the resulting EBCI.}

\item{fs_correction}{Finite-sample correction method used to compute
\eqn{\mu_2}{mu_2} and \eqn{\kappa}{kappa}. These corrections ensure that
we do not shrink the preliminary estimates \code{Y} all the way to zero.
If \code{"PMT"}, use posterior mean truncation, if \code{"FPLIB"} use
limited information Bayesian approach with a flat prior, and if
\code{"none"}, truncate the estimates at \code{0} for \eqn{\mu_2}{mu_2}
and \code{1} for \eqn{\kappa}{kappa}.}
}
\value{
Returns a list with the following components: \describe{

\item{\code{mu2}}{Estimated second moment of
\eqn{\theta-X'\delta}{theta-X*delta}, \eqn{\mu_2}{mu_2}. Vector
of length 2, the first element corresponds to the estimate after the
finite-sample correction as specified by \code{fs_correction}, the second
element is the uncorrected estimate.}

\item{\code{kappa}}{Estimated kurtosis \eqn{\kappa}{kappa} of
\eqn{\theta-X'\delta}{theta-X*delta}. Vector of length 2 with the same
structure as \code{mu2}.}

\item{\code{delta}}{Estimated regression coefficients \eqn{\delta}{delta}}

\item{\code{X}}{Matrix of regressors}

\item{\code{alpha}}{Determines confidence level \eqn{1-\alpha} used.}

\item{\code{df}}{Data frame with components described below.}
}

\code{df} has the following components:

\describe{

\item{\code{w_eb}}{EB shrinkage factors,
\eqn{\mu_{2}/(\mu_{2}+\sigma^2_i)}{mu_2/(mu_2+sigma^2_i)}}

\item{\code{w_opt}}{Length-optimal shrinkage factors}

\item{\code{ncov_pa}}{Maximal non-coverage of parametric EBCIs}

\item{\code{len_eb}}{Half-length of robust EBCIs based on EB shrinkage, so
that the intervals take the form \code{cbind(th_eb-len_eb, th_eb+len_eb)}}

\item{\code{len_op}}{Half-length of robust EBCIs based on length-optimal
shrinkage, so that the intervals take the form \code{cbind(th_op-len_op,
th_op+len_op)}}

\item{\code{len_pa}}{Half-length of parametric EBCIs, which take the form
\code{cbind(th_eb-len_pa, th_eb+len_a)}}

\item{\code{len_us}}{Half-length of unshrunk CIs, which take the form
\code{cbind(th_us-len_us, th_us+len_us)}}

\item{\code{th_us}}{Unshrunk estimate \eqn{Y}}

\item{\code{th_eb}}{EB estimate.}

\item{\code{th_op}}{Estimate based on length-optimal shrinkage.}

\item{\code{se}}{Standard error \eqn{\sigma}{sigma}, as supplied by the
argument \code{se}}

\item{\code{weights}}{Weights used}

\item{\code{residuals}}{The residuals \eqn{Y_i-X_i\delta}{Y_i-X_i*delta}}

}
}
\description{
Computes empirical Bayes estimators based on shrinking towards a regression,
and associated robust empirical Bayes confidence intervals (EBCIs), as well
as length-optimal robust EBCIs.
}
\examples{
## Same specification as in empirical example in Armstrong, Kolesár
## and Plagborg-Møller (2020), but only use data on NY commuting zones
r <- ebci(theta25 ~ stayer25, data=cz[cz$state=="NY", ],
          se=se25, weights=1/se25^2)
}
\references{
{

\cite{Armstrong, Timothy B., Kolesár, Michal, and Plagborg-Møller, Mikkel
(2020): Robust Empirical Bayes Confidence Intervals,
\url{https://arxiv.org/abs/2004.03448}}

}
}
