% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{generate_all_reports}
\alias{generate_all_reports}
\title{Generate and save maps & density plots for RTI and HFTI of all species}
\usage{
generate_all_reports(
  result,
  area_shapefile,
  out_dir,
  map_crs = 4326,
  point_size = 1.5,
  density_fill = "steelblue",
  density_alpha = 0.35
)
}
\arguments{
\item{result}{Lista retornada por \code{compute_indices()}, contendo:
\describe{
\item{processed_data}{Um objeto \code{sf} com as ocorrencias.}
\item{indices}{Data frame com RTI e HFTI medios por especie.}
}}

\item{area_shapefile}{Caminho (string) para o shapefile da area de
estudo (por exemplo, limite do Brasil). Deve ser um arquivo \code{.shp}.}

\item{out_dir}{Caminho (string) para o diretorio onde as imagens e o CSV
serao salvos. Caso nao exista, sera criado automaticamente.}

\item{map_crs}{CRS desejado para os mapas (padrao = 4326, WGS84).}

\item{point_size}{Tamanho dos pontos nos mapas (padrao = 1.5).}

\item{density_fill}{Cor de preenchimento dos graficos de densidade
(padrao = "steelblue").}

\item{density_alpha}{Transparencia do preenchimento dos graficos de
densidade (padrao = 0.35).}
}
\value{
Invisivel. A funcao retorna NULL apos salvar todos os arquivos
em \code{out_dir}.
}
\description{
Esta funcao recebe o resultado de \code{compute_indices()}, um shapefile
de area de estudo e o diretorio de saida. Para cada especie presente em
\code{result$processed_data}, ela gera:
\enumerate{
\item Mapa de RTI (points coloridos por \code{RTI_value})
\item Mapa de HFTI (points coloridos por \code{HFTI_value})
\item Grafico de densidade de RTI (com linha vertical na mediana)
\item Grafico de densidade de HFTI (com linha vertical na mediana)
Alem disso, salva um arquivo CSV com RTI e HFTI medios por especie.
}
}
