#' Ravens data
#'
#' Data from a study of whether ravens fly towards the sound of gunshots (White 2005). Many thanks to Crow White for providing the raw data. There were twelve locations, at which four treatments were applied (1=gunshot, 2-air horn, 3=whistle, 4=no sound).
#' Ravens within a 100 metre radius of the author were counted ten minutes before and ten minutes after each treatment was applied.
#' Primary interest was in assessing if there was an effect of gunshot on raven numbers. Posthoc analyses
#' suggested that ravens were attracted to gunshots in forested areas only.
#' 
#' @docType data
#'
#' @usage data(ravens)
#'
#' @format A dataframe containing:\describe{
#' \item{Before}{The number of ravens before the treatment was applied}
#' \item{After}{The number of ravens after the treatment was applied}
#' \item{delta}{\code{After-Before} count}
#' \item{site}{Location, one of twelve in Jackson Hole, Wyoming's ungulate hunting zone}
#' \item{treatment}{1=gunshot, 2=air horn, 3=whistle, 4=no sound}
#' \item{trees}{1=forested habitat (>300 trees within 100 metres of observer), 0=open}
#' }
#'
#' @keywords datasets
#'
#' @references Crow White (2005) Hunters ring dinner bell for ravens: experimental evidence of a unique foraging strategy.
#' Ecology, \bold{86} 1057-60.
#'
#' @examples
#' data(ravens)
#' ravens1 = ravens[ravens$treatment==1,]
#' t.test(ravens1$Before,ravens1$After,paired=TRUE,alternative="less")
#' boxplot(ravens1$delta,ylab="After-Before counts")
#' abline(h=0,col="red",lty=3)
"ravens"