% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ecotoxicology.R
\name{AdjustAbbott}
\alias{AdjustAbbott}
\title{Calculate corrected efficacy \% with Abbott's formula}
\source{
ehabsoft, last accessed 2015
\url{http://www.ehabsoft.com/ldpline/onlinecontrol.htm}
}
\usage{
AdjustAbbott(smoothedObservedProportion, ps0 = smoothedObservedProportion[1],
  p1 = 1)
}
\arguments{
\item{smoothedObservedProportion}{numeric vector, treated population}

\item{ps0}{numeric vector, control}

\item{p1}{numeric vector, percentage 0 to1 or 0 to 100 (p1=1 or P1=100)}
}
\value{
the corrected efficacy \%
}
\description{
Returns the corrected efficacy \% with Abbott's formula
}
\examples{
#same result as example on Short-term Methods for Estimating the Chronic Toxicity of
#Effluents and Receiving Waters to Freshwater Organisms.TABLE J1. page 312
data(SheepsheadMinnow40SK)
IsMonotonicallyIncreasing(SheepsheadMinnow40SK[,2]/40)
mydata <- cbind(SheepsheadMinnow40SK,
  MakeMonotonicallyIncreasing(cbind(rep(40,6),SheepsheadMinnow40SK[,2])))
AdjustAbbott(mydata[,3])
}
\author{
Jose Gama
}
\references{
Puntener W., 1981
Manual for field trials in plant protection second edition. Agricultural Division, Ciba-Geigy Limited.
}

