% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ecp.R
\name{ecp_plot}
\alias{ecp_plot}
\title{Plot function}
\usage{
ecp_plot(
  data_type,
  from = NULL,
  to = NULL,
  xlim = NULL,
  ylim = NULL,
  x = NULL,
  lambda,
  gamma,
  phi,
  log = FALSE,
  func_type,
  title,
  col = "black",
  lty = 1
)
}
\arguments{
\item{data_type}{specifies whether the input is a x vector of data values or
an expression. Possible types are

- 'data' for data values,

- 'expression' for expression.}

\item{from}{lower x axis limit, by default from = 0.}

\item{to}{upper x axis limit, by default to = 1.}

\item{xlim}{x axis limits, by default xlim = c(from, to).}

\item{ylim}{y axis limits.}

\item{x}{vector of data values when data_type = "data".}

\item{lambda, gamma}{parameter values > 0.}

\item{phi}{parameter value != 0.}

\item{log}{logical value.}

\item{func_type}{specifies the type of function to be plotted. Possible
types are

- 'density' for density plot,

- 'hazard' for hazard plot,

- 'cumulative hazard' for cumulative hazard plot,

- 'survival' for survival plot,

- 'cumulative distribution' for cumulative distribution plot,

- 'quantile' for quantile plot.}

\item{title}{title of the graphic.}

\item{col}{to set the color of the graphic.}

\item{lty}{to set the line type.}
}
\value{
If log = TRUE, numeric value of the logarithm of the function.

If cum_haz = TRUE, numeric value of the cumulative hazard function.

graphic of the chosen ecp function.
}
\description{
Plots the density, cumulative distribution, hazard, cumulative hazard,
survival and quantile functions of the extended Chen-Poisson (ecp)
distribution.
}
\examples{

#  Example of plotting cumulative distribution using an expression

ecp_plot(data_type = "expression", from = 0, to = 6, lambda = 2, gamma = 0.3,
phi = 30, func_type = "cumulative distribution",
title = "Cumulative Distribution Function (Expression)")

#  Example of plotting an unimodal hazard function using an expression

ecp_plot(data_type = "expression", lambda = 2, gamma = 0.3, phi = 30,
func_type = "hazard", title = "Hazard Function (Expression)")

#  Example of plotting an unimodal hazard function using data points

x_data <- seq(0.0000001, 1, by=0.0001)
ecp_plot(data_type = "data", x = x_data, lambda = 2, gamma = 0.3, phi = 30,
func_type = "hazard", title = "Hazard Function (Data Points)")

}
