% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_coverage.R
\name{trace_coverage}
\alias{trace_coverage}
\alias{trace_coverage.log}
\alias{trace_coverage.grouped_log}
\title{Trace Coverage}
\usage{
trace_coverage(log, level = c("log", "trace", "case"), sort = TRUE)

\method{trace_coverage}{log}(log, level = c("log", "trace", "case"), sort = TRUE)

\method{trace_coverage}{grouped_log}(log, level = c("log", "trace", "case"), sort = TRUE)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{level}{\code{\link{character}} (default \code{"log"}): Level of granularity for the analysis: \code{"log"} (default),
\code{"trace"}, or \code{"case"}. For more information, see \code{vignette("metrics", "edeaR")} and \strong{Details} below.}

\item{sort}{\code{\link{logical}} (default \code{TRUE}): Sort output on count. Only for levels with frequency count output.}
}
\description{
Analyses the structuredness of a log by use of trace frequencies.
}
\details{
Argument \code{level} has the following options:
\itemize{
\item At \code{"log"} level, summary statistics of the coverage of traces are returned.
\item On \code{"trace"} level, the absolute and relative frequency of each trace are returned.
\item On \code{"case"} level, the coverage of the corresponding trace is returned for each case.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{trace_coverage(log)}: Calculates trace coverage metric for a \code{\link[bupaR]{log}}.

\item \code{trace_coverage(grouped_log)}: Calculates trace coverage metric for a \code{\link[bupaR]{grouped_log}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
Other metrics: 
\code{\link{activity_frequency}()},
\code{\link{activity_presence}()},
\code{\link{end_activities}()},
\code{\link{idle_time}()},
\code{\link{number_of_repetitions}()},
\code{\link{number_of_selfloops}()},
\code{\link{number_of_traces}()},
\code{\link{processing_time}()},
\code{\link{resource_frequency}()},
\code{\link{resource_involvement}()},
\code{\link{resource_specialisation}()},
\code{\link{start_activities}()},
\code{\link{throughput_time}()},
\code{\link{trace_length}()}
}
\concept{metrics}
\concept{metrics_structuredness}
