% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metro_multicriteria.R
\name{metro_multicriteria}
\alias{metro_multicriteria}
\title{Metro Map Layout}
\usage{
metro_multicriteria(object, xy, l = 2, gr = 0.0025, w = rep(1, 5), bsize = 5)
}
\arguments{
\item{object}{original graph}

\item{xy}{initial layout of the original graph}

\item{l}{desired multiple of grid point spacing. (l*gr determines desired edge length)}

\item{gr}{grid spacing. (l*gr determines desired edge length)}

\item{w}{weight vector for criteria (see details)}

\item{bsize}{number of grid points a station can move away rom its original position}
}
\value{
new coordinates for stations
}
\description{
Metro map layout based on multicriteria optimization
}
\details{
The function optimizes the following five criteria using a hill climbing algorithm:
\itemize{
\item \emph{Angular Resolution Criterion}: The angles of incident edges at each station should be maximized, because if there is only a small angle between any two adjacent edges, then it can become difficult to distinguish between them
\item \emph{Edge Length Criterion}: The edge lengths across the whole map should be approximately equal to ensure regular spacing between stations. It is based on the preferred multiple, l, of the grid spacing, g. The purpose of the criterion is to penalize edges that are longer than or shorter than lg.
\item \emph{Balanced Edge Length Criterion}: The length of edges incident to a particular station should be similar
\item \emph{Line Straightness Criterion}: (not yet implemented) Edges that form part of a line should, where possible, be co-linear either side of each station that the line passes through
\item \emph{Octiinearity Criterion}: Each edge should be drawn horizontally, vertically, or diagonally at 45 degree, so we penalize edges that are not at a desired angle
see \href{https://github.com/schochastics/edgebundle}{online} for more plotting tips
}
}
\examples{
# the algorithm has problems with parallel edges
library(igraph)
g <- simplify(metro_berlin)
xy <- cbind(V(g)$lon, V(g)$lat) * 100

# the algorithm is not very stable. try playing with the parameters
xy_new <- metro_multicriteria(g, xy, l = 2, gr = 0.5, w = c(100, 100, 1, 1, 100), bsize = 35)
}
\references{
Stott, Jonathan, et al. "Automatic metro map layout using multicriteria optimization." IEEE Transactions on Visualization and Computer Graphics 17.1 (2010): 101-114.
}
\author{
David Schoch
}
