% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-ideb.R
\name{get_ideb}
\alias{get_ideb}
\title{Get IDEB (Índice de Desenvolvimento da Educação Básica) data}
\usage{
get_ideb(
  year,
  level = c("escola", "municipio"),
  stage = c("anos_iniciais", "anos_finais", "ensino_medio"),
  uf = NULL,
  quiet = FALSE
)
}
\arguments{
\item{year}{The year of the IDEB (available: 2017, 2019, 2021, 2023).}

\item{level}{The aggregation level:
\itemize{
\item \code{"escola"}: School level
\item \code{"municipio"}: Municipality level
}}

\item{stage}{The education stage:
\itemize{
\item \code{"anos_iniciais"}: Early elementary (1st-5th grade)
\item \code{"anos_finais"}: Late elementary (6th-9th grade)
\item \code{"ensino_medio"}: High school
}}

\item{uf}{Optional. Filter by state (UF code or abbreviation).}

\item{quiet}{Logical. If \code{TRUE}, suppresses progress messages.}
}
\value{
A tibble with IDEB data in tidy format.
}
\description{
Downloads and processes IDEB data from INEP. IDEB is the main indicator
of education quality in Brazil, combining student performance (from SAEB)
with grade promotion rates.
}
\details{
IDEB is calculated every two years since 2005 based on:
\itemize{
\item \strong{Learning}: Average scores in Portuguese and Mathematics from SAEB
\item \strong{Flow}: Grade promotion rate (inverse of repetition/dropout)
}

The index ranges from 0 to 10. Brazil's national goal is to reach 6.0
by 2022 (the level of developed countries in PISA).

\strong{Note:} IDEB data is relatively small compared to other INEP datasets,
so no \code{n_max} parameter is provided.
}
\section{Data source}{

Official IDEB portal: \url{https://www.gov.br/inep/pt-br/areas-de-atuacao/pesquisas-estatisticas-e-indicadores/ideb}
}

\examples{
\donttest{
# get school-level IDEB for early elementary in 2021
ideb_escolas <- get_ideb(2021, level = "escola", stage = "anos_iniciais")

# get municipality-level IDEB for São Paulo state
ideb_sp <- get_ideb(2021, level = "municipio", stage = "anos_iniciais", uf = "SP")

# get high school IDEB for all municipalities
ideb_em <- get_ideb(2023, level = "municipio", stage = "ensino_medio")
}
}
