% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAST.R
\name{CAST.sample}
\alias{CAST.sample}
\title{Sample from the various strata according to the schedule set by 'ns'.
Ignore all precincts that are known (i.e., have been previously audited).}
\usage{
CAST.sample(
  Z,
  ns,
  strata = NULL,
  seed = NULL,
  print.trail = FALSE,
  known = "known"
)
}
\arguments{
\item{Z}{elec.data object (voter matrix)}

\item{ns}{EITHER an audit.plan or a vector of sample sizes for the strata.
Names must correspond ot the names of the strata.  If ns is an audit plan,
then the strata variable should not be passed as well.}

\item{strata}{Name of the stratification column of Z.  Not needed if audit
plan also being passed in case of CAST.sample. NULL means single strata.}

\item{seed}{Seed to use--for reproducability.}

\item{print.trail}{Print out diagnostics.}

\item{known}{The column of known precincts that should thus not be selected.
Similar to "drop", above.}
}
\value{
: List of precincts to be audited.
}
\description{
Sample from the various strata according to the schedule set by 'ns'.
Ignore all precincts that are known (i.e., have been previously audited).
}
\examples{
Z = make.cartoon()
samp.info = CAST.calc.sample( Z )
samp.info
samp = CAST.sample( Z, samp.info )

}
