% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_brackets.R
\name{harmonize_income_brackets}
\alias{harmonize_income_brackets}
\title{Harmonize Income Brackets Across Vintages}
\usage{
harmonize_income_brackets(
  data,
  dataset,
  vintage,
  strict_matching = TRUE,
  comparison_vintages = NULL
)
}
\arguments{
\item{data}{A data frame containing income bracket data}

\item{dataset}{Character, either "ami" or "fpl"}

\item{vintage}{Integer, the year of the data vintage}

\item{strict_matching}{Logical, if TRUE (default) only keeps brackets that
exist in both vintages being compared. If FALSE, keeps all brackets.}

\item{comparison_vintages}{Integer vector of length 2, the vintages being
compared (e.g., c(2018, 2022)). Required when strict_matching = TRUE.}
}
\value{
A list with components:
\itemize{
\item \code{data}: The harmonized data frame
\item \code{warnings}: Character vector of any warnings about bracket mismatches
\item \code{dropped_brackets}: Character vector of brackets that were dropped
}
}
\description{
Harmonizes income bracket categories when comparing data across different
vintage years. This is necessary because some datasets (particularly AMI)
have different bracket definitions across years.
}
\details{
\subsection{Dataset-Specific Bracket Definitions}{
\subsection{AMI (Area Median Income)}{
\itemize{
\item \strong{2018}: 3 brackets
\itemize{
\item \code{very_low}: Very low income (typically <50\% AMI)
\item \code{low_mod}: Low to moderate income (typically 50-80\% AMI)
\item \code{mid_high}: Middle to high income (typically >80\% AMI)
}
\item \strong{2022}: 5 brackets
\itemize{
\item \code{very_low}: Very low income (same as 2018)
\item \code{low_mod}: Low to moderate income (same as 2018)
\item \code{mid_high}: Middle to high income (narrower than 2018)
\item \verb{100-150\%}: 100-150\% of AMI (new in 2022)
\item \verb{150\%+}: Above 150\% of AMI (new in 2022)
}
}
}

\subsection{FPL (Federal Poverty Level)}{
\itemize{
\item \strong{Both 2018 and 2022}: 5 brackets
\itemize{
\item \verb{0-100\%}: Below poverty line
\item \verb{100-150\%}: 100-150\% of FPL
\item \verb{150-200\%}: 150-200\% of FPL
\item \verb{200-400\%}: 200-400\% of FPL
\item \verb{400\%+}: Above 400\% of FPL
}
}
}

}
}
\keyword{internal}
