% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_dissimilarity_from_txt_file}
\alias{get_dissimilarity_from_txt_file}
\title{Recover the square matrix of distance between cocktails where the index (i,j)
of the matrix is the distance between cocktails i and j in the csv file containing
results of genetic algorithm}
\usage{
get_dissimilarity_from_txt_file(filename, ATCtree, normalization = TRUE)
}
\arguments{
\item{filename}{: the name of the file returned by the print_csv function.}

\item{ATCtree}{: ATC tree with upper bound of the DFS (without the root)}

\item{normalization}{: Do we keep the distance between cocktail in the range [0;1] ?}
}
\value{
The square matrix of distances between cocktails
}
\description{
Recover the square matrix of distance between cocktails where the index (i,j)
of the matrix is the distance between cocktails i and j in the csv file containing
results of genetic algorithm
}
\examples{
\donttest{
 data("ATC_Tree_UpperBound_2024")
 
 distance_matrix = get_dissimilarity_from_txt_file(filename = '250e_700ind_0.2mr_0ne_2alpha.txt',
                        ATCtree = ATC_Tree_UpperBound_2024, normalization = TRUE)
}
}
