% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spearman_brown.R
\name{spearman_brown}
\alias{spearman_brown}
\title{Spearman–Brown Prophecy Formula}
\usage{
spearman_brown(rxx, input, type = c("r", "l"))
}
\arguments{
\item{rxx}{A numeric value indicating the original reliability
(must be between 0 and 1, exclusive).}

\item{input}{A numeric value indicating either:
\itemize{
\item the ratio of new test length to original test length (if type = "r"), or
\item the desired reliability of the new test (if type = "l").
}}

\item{type}{Character string specifying the calculation type:
\describe{
\item{"r"}{Compute new reliability given the length ratio.}
\item{"l"}{Compute the length ratio required to achieve a desired reliability.}
}}
}
\value{
A named list depending on \code{type}:
\describe{
\item{reliability}{Predicted reliability of the new test (if type = "r").}
\item{ratio}{Required ratio of new test length to original test length
(if type = "l").}
}
}
\description{
Compute the predicted test reliability after changing test length, or compute
the required test-length ratio to achieve a desired reliability, using the
Spearman–Brown prophecy formula.
}
\details{
The Spearman–Brown prophecy formula is:
\deqn{r_{yy} = \frac{k r_{xx}}{1 + (k - 1) r_{xx}},}
where \eqn{r_{xx}} is the original reliability and \eqn{k} is the ratio of the
new test length to the original test length.

Solving for \eqn{k} gives:
\deqn{k = \frac{r_{yy}(1 - r_{xx})}{r_{xx}(1 - r_{yy})}.}
}
\examples{
spearman_brown(0.7, 3.86, "r")
spearman_brown(0.7, 0.90, "l")

}
