% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-emuRtrackdata.R
\name{convert_wideToLong}
\alias{convert_wideToLong}
\title{convert tracks of a tibble trackdata object to the long form}
\usage{
convert_wideToLong(td, calcFreqs = FALSE)
}
\arguments{
\item{td}{wide form trackdata tibble object}

\item{calcFreqs}{calculate an additional column containing 
frequency values from 0-nyquist frequency that match T1-TN (can be quite useful for spectral data)}
}
\value{
long form trackdata tibble object
}
\description{
Converts a trackdata tibble object of the form (==wide):
\tabular{lllllll}{
sl_rowIdx \tab ... \tab T1 \tab T2 \tab T3 \tab ... \tab TN\cr
1 \tab ... \tab T1_value \tab T2_value \tab T3_value \tab ... \tab TN_value
}
to its long form equivalent:
\tabular{llll}{
sl_rowIdx \tab ... \tab track_name \tab track_value \cr
1 \tab ... \tab T1 \tab T1_value \cr
1 \tab ... \tab T2 \tab T2_value \cr
1 \tab ... \tab T3 \tab T3_value \cr
... \tab ... \tab ... \tab ... \cr
1 \tab ... \tab TN \tab TN_value \cr
}
}
