% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energyloss.R
\name{energyloss}
\alias{energyloss}
\title{Energy Loss Calculation}
\usage{
energyloss(yt, mxt, mxpt)
}
\arguments{
\item{yt}{A tensor representing the target values.}

\item{mxt}{A tensor representing the model's stochastic predictions.}

\item{mxpt}{A tensor representing another draw of the model's stochastic predictions.}
}
\value{
A scalar representing the calculated energy loss.
}
\description{
This function calculates the energy loss for given tensors. The loss is calculated
as the mean of the L2 norms between \code{yt} and \code{mxt} and between \code{yt} and \code{mxpt},
subtracted by half the mean of the L2 norm between \code{mxt} and \code{mxpt}.
}
\keyword{internal}
