% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotEnrich}
\alias{plotEnrich}
\title{plotEnrich}
\usage{
plotEnrich(
  df,
  showTerms = 20,
  numChar = 40,
  y = "Count",
  orderBy = "P.value",
  xlab = NULL,
  ylab = NULL,
  title = NULL
)
}
\arguments{
\item{df}{(Required). A single data.frame from a list of Enrichr output.}

\item{showTerms}{(Optional). Number of terms to show. Default is \code{20}.}

\item{numChar}{(Optional). A single integer. Default is \code{40}.
Indicates the number characters to keep in the term description.}

\item{y}{(Optional). A character string. Default is \code{"Count"}.
Indicates the variable that should be mapped to the y-axis.
It can be either \code{"Count"} or \code{"Ratio"}. 
Results that includes background genes in the analysis can only show \code{"Count"}.}

\item{orderBy}{(Optional). A character string. Default is \code{"P.value"}.
Indicates how to order the Enrichr results before subsetting to keep top \code{N} terms.
It can be one of these:
\itemize{
\item \code{"P.value"}
\item \code{"Adjusted.P.value"} (or \code{"FDR"})
\item \code{"Combined.Score"} (or \code{"Score"})
}}

\item{xlab}{(Optional). A character string. Default is \code{NULL}.
Indicates the x-axis label.}

\item{ylab}{(Optional). A character string. Default is \code{NULL}.
Indicates the y-axis label.}

\item{title}{(Optional). A character string. Default is \code{NULL}
Indicates the main title for the graphic.}
}
\value{
A \code{\link[ggplot2]{ggplot}} plot object
}
\description{
Visualise a Enrichr output as barplot
}
\details{
Visualise Enrichr result from a selected gene-set library as barplot.
}
\examples{
# data(input) # Load example input genes
# dbs <- c("GO_Molecular_Function_2023", "GO_Cellular_Component_2023",
#          "GO_Biological_Process_2023")
# if (getOption("enrichR.live")) {
#   enriched <- enrichr(input, dbs)
#   print(head(enriched[[1]]))
#   # Plot top 20 terms from "GO_Biological_Process_2023" and ordered by P-value
#   plotEnrich(enriched[[3]], showTerms = 20, numChar = 50, y = "Count",
#              orderBy = "P.value")
# }
}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
\author{
I-Hsuan Lin \email{i-hsuan.lin@manchester.ac.uk}
}
