% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseaScores.R
\name{gseaScores}
\alias{gseaScores}
\title{Calculate GSEA Running Enrichment Scores}
\usage{
gseaScores(geneList, geneSet, exponent = 1, fortify = FALSE)
}
\arguments{
\item{geneList}{a named numeric vector of gene statistics (e.g., t-statistics or log-fold changes), sorted in decreasing order.}

\item{geneSet}{a character vector of gene IDs belonging to the gene set.}

\item{exponent}{a numeric value defining the weight of the running enrichment score. Default is 1.}

\item{fortify}{logical. If TRUE, returns a data frame with columns \code{x}, \code{runningScore}, and \code{position}.
If FALSE (default), returns the enrichment score (ES).}
}
\value{
If \code{fortify = TRUE}, a data frame containing the running enrichment scores and positions.
If \code{fortify = FALSE}, a numeric value representing the Enrichment Score (ES).
}
\description{
Calculate GSEA Running Enrichment Scores
}
\author{
Guangchuang Yu
}
