% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateEnvirem.R
\name{generateEnvirem}
\alias{generateEnvirem}
\title{Generate ENVIREM rasters}
\usage{
generateEnvirem(
  masterstack,
  solradstack = NULL,
  monthPET = NULL,
  var,
  tempScale = 1,
  precipScale = 1
)
}
\arguments{
\item{masterstack}{rasterStack containing all monthly precipitation, 
min temperature, max temperature, and optionally mean temperature rasters.}

\item{solradstack}{rasterStack of monthly solar radiation, can be \code{NULL} if not needed.}

\item{monthPET}{rasterStack of monthly potential evapotranspiration. If \code{NULL}, 
will be calculated internally. If supplied, solradstack is not needed.}

\item{var}{vector of names of variables to generate, see Details.}

\item{tempScale}{integer; scaling factor for the temperature data, see \link{envirem} for 
additional details.}

\item{precipScale}{integer; scaling factor for the precipitation data, see \link{envirem}
for additional details.}
}
\value{
rasterStack
}
\description{
Generates rasters from an input dataset.
}
\details{
The function \code{\link{verifyRasterNames}} should be used to 
verify that the appropriate rasters are present in \code{masterstack}.


Possible variables to generate include:\cr
\cr
annualPET \cr
aridityIndexThornthwaite \cr
climaticMoistureIndex \cr
continentality \cr
embergerQ \cr
growingDegDays0 \cr
growingDegDays5 \cr
maxTempColdest \cr
minTempWarmest \cr
meanTempColdest \cr
meanTempWarmest \cr
monthCountByTemp10 \cr
PETColdestQuarter \cr
PETDriestQuarter \cr
PETseasonality \cr
PETWarmestQuarter \cr
PETWettestQuarter \cr
thermicityIndex \cr

If \code{var = 'all'}, then all of the variables will be generated.
}
\examples{
\donttest{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)

# create stack of temperature and precipitation rasters
# and stack of solar radiation rasters
solradFiles <- grep('solrad', rasterFiles, value=TRUE)
worldclim <- rast(setdiff(rasterFiles, solradFiles))
solar <- rast(solradFiles)

# set up naming scheme - only precip is different from default
assignNames(precip = 'prec_##')

# generate all possible envirem variables
generateEnvirem(worldclim, solar, var='all', tempScale = 10)

# set back to defaults
assignNames(reset = TRUE)
}
}
\author{
Pascal Title
}
