% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{get_envs_in_env}
\alias{get_envs_in_env}
\title{Find user environments inside another user environment}
\usage{
get_envs_in_env(env_name, path, path_to_envs_found, rootenvir = .GlobalEnv)
}
\arguments{
\item{env_name}{name of the user environment where the search for other user environments
should be carried out.}

\item{path}{array containing the user environment names leading to the \code{env_name} environment.}

\item{path_to_envs_found}{array of environment names found so far including their path 
(as in \code{testenv$env1}). Note that the path does NOT include the *location* of the user
environments which is actually the system or package environment where the crawling starts
defined by parameter \code{rootenvir}.}

\item{rootenvir}{root environment specifying the location where the crawl of user environmnts
starts. This is needed for the \code{eval()} to work when resolving the name of the input environment
\code{env_name} into an enviroment. Ex: if we are crawling the environments defined in the envnames package,
\code{rootenvir} should be equal to the "package:envnames" environment, and here is where we are going to
find all the user environments that are crawled by this process as e.g.:
\code{testenv}
\code{testenv$env1}
\code{...}
i.e. all these environments will be \code{eval}uated in the \code{rootenvir} environment which
in this case is the "package:envnames" environment.}
}
\value{
Either an updated \code{path_to_envs_found} with the user environments found so far
in the user environments tree or \code{TRUE}, which indicates that a leaf in the user
environments tree hanging from \code{rootenvir} has been reached.
}
\description{
Function that looks for user environments defined within a given user environment.
}
\keyword{internal}
