% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endemic_channel.R
\name{endemic_outliers}
\alias{endemic_outliers}
\title{Modifies the historic incidence to handle with the observations of epidemic
years}
\usage{
endemic_outliers(
  historic,
  outlier_years,
  outliers_handling,
  geometric_method = "shifted"
)
}
\arguments{
\item{historic}{Historic incidence counts}

\item{outlier_years}{A numeric vector with the outlier years}

\item{outliers_handling}{A string with the handling decision regarding
outlier years
\itemize{
\item ignored = data from outlier years will not take into account
\item included = data from outlier years will take into account
\item replaced_by_median = data from outlier years will be replaced with the
median and take into account
\item replaced_by_mean = data from outlier years will be replaced with the
mean and take into account
\item replaced_by_geometric_mean = data from outlier years will be replaced with
the geometric mean and take into account
}}

\item{geometric_method}{A string with the selected method for geometric mean
calculation; see: geometric_mean}
}
\value{
A modified historic incidence
}
\description{
Function that modifies an historic incidence by including,
ignoring or replacing the observations of epidemic years
}
\keyword{internal}
