% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{.distributional_family}
\alias{.distributional_family}
\title{Get the underlying distributions names from a \verb{<distribution>} object from
the \pkg{distributional} package in \R distribution naming convention.}
\usage{
.distributional_family(x, base_dist = TRUE)
}
\arguments{
\item{x}{An \verb{<distribution>} object.}

\item{base_dist}{A boolean \code{logical} for whether to return the name of a
transformed distribution (e.g. \code{"mixture"} or \code{"truncated"}) or the
underlying distribution type (e.g. \code{"gamma"} or \code{"lnorm"}). Default is
\code{TRUE}.}
}
\value{
A \code{character} vector.
}
\description{
Get the underlying distributions names from a \verb{<distribution>} object from
the \pkg{distributional} package in \R distribution naming convention.
}
\details{
Get and standardise distribution name. For untransformed
distributions (e.g. \code{\link[distributional:dist_gamma]{distributional::dist_gamma()}}) it will return the
distribution name. For transformed distributions (e.g.
\code{\link[distributional:dist_mixture]{distributional::dist_mixture()}}) it will get the name of the underlying
distribution(s) by default (\code{base_dist = TRUE}). Distribution names are
returned in the \R naming style (e.g. lognormal is \code{"lnorm"}). When
\code{base_dist = FALSE} transformed distributions return the name of the
transformation (e.g. \code{"mixture"}).
}
\keyword{internal}
