% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.epiparameter}
\alias{plot.epiparameter}
\title{Plot method for \verb{<epiparameter>} class}
\usage{
\method{plot}{epiparameter}(x, cumulative = FALSE, ...)
}
\arguments{
\item{x}{An \verb{<epiparameter>} object.}

\item{cumulative}{A boolean \code{logical}, default is \code{FALSE}.
\code{cumulative = TRUE} plots the cumulative distribution function (CDF).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
These functions are invoked for their side effect of drawing
  on the active graphics device.
}
\description{
Plot an \verb{<epiparameter>} object by displaying the either the
probability mass function (PMF), (in the case of discrete distributions)
or probability density function (PDF) (in the case of continuous
distributions), or the cumulative distribution function (CDF).
}
\details{
By default if the \code{xlim} argument is not specified the distribution is
plotted between day 0 and the 99th quantile of the distribution.
Alternatively, a \code{numeric} vector of length 2 with the
first and last day to plot on the x-axis can be supplied to \code{xlim}
(through \link{...}).
}
\examples{
# plot continuous epiparameter
ep <- epiparameter(
  disease = "ebola",
  epi_name = "incubation_period",
  prob_distribution = create_prob_distribution(
    prob_distribution = "gamma",
    prob_distribution_params = c(shape = 2, scale = 1)
  )
)
plot(ep)

# plot different day range (x-axis)
plot(ep, xlim = c(0, 10))

# plot CDF
plot(ep, cumulative = TRUE)

# plot discrete epiparameter
ep <- discretise(ep)
plot(ep)
}
\author{
Joshua W. Lambert
}
