% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_write_xlsxs}
\alias{epitrax_write_xlsxs}
\title{Write reports from EpiTrax object to Excel files}
\usage{
epitrax_write_xlsxs(epitrax, fsys)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{fsys}{Filesystem list containing paths for internal and public reports.}
}
\value{
The original EpiTrax object, unchanged.
}
\description{
\code{epitrax_write_xlsxs} writes the internal and public reports from an EpiTrax
object to Excel files in the specified filesystem. Combines all internal reports
into one Excel file with separate sheets for each report. Likewise with public
reports.
}
\examples{
fsys <- list(
  internal = file.path(tempdir(), "internal_reports"),
  public = file.path(tempdir(), "public_reports"),
  settings = file.path(tempdir(), "report_settings")
)
fsys <- setup_filesystem(fsys)

data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_preport_ytd_rates() |>
 epitrax_write_xlsxs(fsys = fsys)

# Cleanup
unlink(unlist(fsys, use.names = FALSE), recursive = TRUE)
}
