% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{compute_trend}
\alias{compute_trend}
\title{Compute the report trend}
\usage{
compute_trend(current, historical, threshold = 0)
}
\arguments{
\item{current}{List. Current data.}

\item{historical}{List. Historical comparison data.}

\item{threshold}{Numeric. Percentage threshold (as decimal) for determining
trend significance. Values within this percentage of the historical value
are considered "Expected". Defaults to 0.0 (any difference triggers trend).}
}
\value{
Character vector containing the trend labels.
}
\description{
'compute_trend' compares values of two columns and produces a new column
containing the trend result. The trend is represented by one of three values:
\itemize{
\item "Elevated": increase from baseline
\item "Less Than Expected": decrease from baseline
\item "Expected": no change from baseline
}
}
\examples{
# Without threshold - any difference triggers trend
compute_trend(c(5, 10, 10), c(3, 10, 11))

# With 15\% threshold - small changes are "Expected"
compute_trend(c(5, 10, 10), c(3, 10, 11), threshold = 0.15)
}
