% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_ireport_monthly_counts_all_yrs}
\alias{epitrax_ireport_monthly_counts_all_yrs}
\title{Create monthly counts internal report for all years from an EpiTrax object}
\usage{
epitrax_ireport_monthly_counts_all_yrs(epitrax)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}
}
\value{
Updated EpiTrax object with monthly counts reports for each year
added to the \code{internal_reports} field.
}
\description{
\code{epitrax_ireport_monthly_counts_all_yrs} generates internal reports of
monthly counts for each year in the EpiTrax object data.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_ireport_monthly_counts_all_yrs()

names(epitrax$internal_reports)
}
