% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{mmwr_week_to_month}
\alias{mmwr_week_to_month}
\title{Convert MMWR week to calendar month}
\usage{
mmwr_week_to_month(data)
}
\arguments{
\item{data}{Dataframe. Must contain columns:
\itemize{
\item \code{patient_mmwr_year} (integer)
\item \code{patient_mmwr_week} (integer)
}}
}
\value{
The input data frame with an added "month" column (integer 1-12) and
removed \code{patient_mmwr_week} column.
}
\description{
\code{mmwr_week_to_month} calculates the calendar month from the
\code{patient_mmwr_week} and \code{patient_mmwr_year} fields of the EpiTrax data.
The result is stored in the \code{month} column and the \code{patient_mmwr_week}
column is removed.
}
\examples{
df <- data.frame(
  patient_mmwr_year = 2020L,
  patient_mmwr_week = 1L,
  patient_disease = "A"
)
mmwr_week_to_month(df)
}
