% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-npi.R
\name{pi_add_vaccine}
\alias{pi_add_vaccine}
\title{Vaccination (pharmaceutical intervention)}
\usage{
pi_add_vaccine(
  model,
  preval,
  susceptibility_reduction,
  transmission_reduction,
  recovery_enhancer,
  death_reduction
)
}
\arguments{
\item{model}{epiworldR model.}

\item{preval}{Initial prevalence of the vaccine.}

\item{susceptibility_reduction}{Reduction in susceptibility probability due
to vaccine.}

\item{transmission_reduction}{Reduction in transmission probability due to
vaccine.}

\item{recovery_enhancer}{Probability increase in recovery due to vaccine.}

\item{death_reduction}{Reduction in death probability due to vaccine.}
}
\value{
Returns an object of class epiworld_model, where model is
substituted with the model name.
}
\description{
Vaccination (pharmaceutical intervention)
}
\examples{
library(epiworldR) # for ModelSEIRCONN function
model <- ModelSEIRCONN("COVID-19", n = 1000, prevalence = 0.05,
                       contact_rate = 4, transmission_rate = 0.1,
                       incubation_days = 7, recovery_rate = 0.14)
run(model, ndays = 100, seed = 123)
pi_add_vaccine(model, preval = .8, susceptibility_reduction = .9,
                transmission_reduction = .5, recovery_enhancer = .5,
                death_reduction = .9)
}
\seealso{
Other interventions: 
\code{\link{interventions_add_all}()},
\code{\link{npi_add_masking}()},
\code{\link{npi_add_school_closure}()}
}
\concept{interventions}
