% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_aspatial_siri_inputs.R
\name{check_aspatial_siri_inputs}
\alias{check_aspatial_siri_inputs}
\title{Helper function to check the validity of inputs to the \code{siri_model_summer}
and \code{siri_model_winter} functions.}
\usage{
check_aspatial_siri_inputs(inputs)
}
\arguments{
\item{inputs}{A nested list with named elements:
\describe{
\item{\code{replicates}}{Number of replicate simulation runs.}
\item{\code{time_steps}}{Number of simulation time steps.}
\item{\code{populations}}{Number of populations.}
\item{\code{stages}}{Number of life cycle stages.}
\item{\code{compartments}}{Number of disease compartments (e.g., 3 for a
SIR model).}
\item{\code{abundance_threshold}}{A quasi-extinction threshold at
which a population becomes extinct.}
\item{\code{mortality}}{A vector of mortality rates, one for each
combination of stages and compartments.}
\item{\code{mortality_unit}}{A vector indicating whether mortality rates
are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{fecundity}}{A vector of fecundity rates, one for each
combination of stages and compartments for which fecundity applies.}
\item{\code{fecundity_unit}}{A vector indicating whether fecundity rates
are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{fecundity_mask}}{A vector indicating which stages and
compartments reproduce.}
\item{\code{transmission}}{A vector of transmission rates, one for each
combination of stages and compartment for which transmission applies (see
\code{transmission_mask} below.}
\item{\code{transmission_unit}}{A vector indicating whether mortality
rates are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{transmission_mask}}{A vector indicating which stages and
compartments are subject to transmission (i.e., classes susceptible to
infection.)}
\item{\code{recovery}}{A vector of recovery rates, one for each
combination of stages and compartment for which recovery applies (see
\code{recovery_mask} below.)}
\item{\code{recovery_unit}}{A vector indicating whether mortality rates
are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{recovery_mask}}{A vector indicating which compartments are
subject to recovery (i.e., infected classes that can recover.)}
\item{\code{r}}{Simulation replicate.}
\item{\code{tm}}{Simulation time step.}
\item{\code{carrying_capacity}}{Array of carrying capacity values for
each population at time step.}
\item{\code{breeding_season_length}}{Array of breeding season lengths in
days for each population at time step.}
\item{\code{segment_abundance}}{Matrix of (current) abundance for each
stage-compartment combo (rows) and population (columns) at time step.}
\item{\code{occupied_indices}}{Array of indices for populations occupied
at (current) time step.}
\item{\code{simulator}}{\code{\link[poems:SimulatorReference]{poems::SimulatorReference}} object with
dynamically accessible \emph{attached} and \emph{results} lists.}
\item{\code{additional attributes}}{Additional attributes when the
transformation is optionally nested in a list.}
}}
}
\value{
A list identical to the inputs (if there are no errors.)
}
\description{
This is an internal function that checks inputs to the \code{disease_simulator}
function to make sure they are valid, and sets default values for needed
inputs if their values are not supplied. The possible inputs for this
function are the same as the possible inputs to the \code{disease_simulator}
function.
}
