% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspatial_siri_seasons.R
\name{siri_model_summer}
\alias{siri_model_summer}
\title{Simulate a \emph{Mycoplasma gallisepticum} Outbreak in the Breeding Season}
\usage{
siri_model_summer(inputs)
}
\arguments{
\item{inputs}{A nested list with named elements:
\describe{
\item{\code{replicates}}{Number of replicate simulation runs.}
\item{\code{time_steps}}{Number of simulation time steps.}
\item{\code{populations}}{Number of populations.}
\item{\code{stages}}{Number of life cycle stages.}
\item{\code{compartments}}{Number of disease compartments (e.g., 3 for a
SIR model).}
\item{\code{abundance_threshold}}{A quasi-extinction threshold at
which a population becomes extinct.}
\item{\code{mortality}}{A vector of mortality rates, one for each
combination of stages and compartments.}
\item{\code{mortality_unit}}{A vector indicating whether mortality rates
are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{fecundity}}{A vector of fecundity rates, one for each
combination of stages and compartments for which fecundity applies.}
\item{\code{fecundity_unit}}{A vector indicating whether fecundity rates
are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{fecundity_mask}}{A vector indicating which stages and
compartments reproduce.}
\item{\code{transmission}}{A vector of transmission rates, one for each
combination of stages and compartment for which transmission applies (see
\code{transmission_mask} below.}
\item{\code{transmission_unit}}{A vector indicating whether mortality
rates are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{transmission_mask}}{A vector indicating which stages and
compartments are subject to transmission (i.e., classes susceptible to
infection.)}
\item{\code{recovery}}{A vector of recovery rates, one for each
combination of stages and compartment for which recovery applies (see
\code{recovery_mask} below.)}
\item{\code{recovery_unit}}{A vector indicating whether mortality rates
are daily or seasonal. 1 indicates seasonal, 0 indicates daily.}
\item{\code{recovery_mask}}{A vector indicating which compartments are
subject to recovery (i.e., infected classes that can recover.)}
\item{\code{r}}{Simulation replicate.}
\item{\code{tm}}{Simulation time step.}
\item{\code{carrying_capacity}}{Array of carrying capacity values for
each population at time step.}
\item{\code{breeding_season_length}}{Array of breeding season lengths in
days for each population at time step.}
\item{\code{segment_abundance}}{Matrix of (current) abundance for each
stage-compartment combo (rows) and population (columns) at time step.}
\item{\code{occupied_indices}}{Array of indices for populations occupied
at (current) time step.}
\item{\code{simulator}}{\code{\link[poems:SimulatorReference]{poems::SimulatorReference}} object with
dynamically accessible \emph{attached} and \emph{results} lists.}
\item{\code{additional attributes}}{Additional attributes when the
transformation is optionally nested in a list.}
}}
}
\value{
An abundance matrix with \code{populations} columns and
\code{stages*compartments} rows, updated from the \code{segment_abundance} input in
\code{inputs} according to demography and disease dynamics.
}
\description{
Simulate a \emph{Mycoplasma gallisepticum} outbreak during the breeding season
day-by-day in a population of house finches (\emph{Haemorhous mexicanus}). Uses a
SIRI model (Susceptible-Infected 1- Recovered-Infected 2+) and includes
demographic stochasticity in fecundity, mortality, and infection.
}
\details{
The function can also handle the case in which there are no infected
individuals. The principal difference between this function and the one for
simulating an outbreak in the non-breeding season is that this one includes
fecundity.
}
