% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/futilityAnalysis.R
\name{futilityAnalysis}
\alias{futilityAnalysis}
\title{Futility Analysis Across Interventions for CRT, MST, or SRT Designs}
\usage{
futilityAnalysis(
  method = c("crt", "mst", "srt"),
  data,
  outcome = "posttest",
  interventions = "interventions",
  Random = "schools",
  Nsim = 10000,
  Threshold = 0.05,
  FutThreshold = 0.8,
  continuous_covariates = NULL,
  categorical_covariates = NULL
)
}
\arguments{
\item{method}{The trial design type: "crt", "mst", or "srt".}

\item{data}{A data frame containing the variables including outcome, predictors, the clustering variable, and the intervention.}

\item{outcome}{The name of the outcome (post-test) variable.}

\item{interventions}{A string specifying the intervention variable.}

\item{Random}{The name of the clustering variable (e.g., schools or sites) for CRT and MST designs.}

\item{Nsim}{Number of MCMC iterations to be performed. A minimum of 10,000 is recommended to ensure convergence.}

\item{Threshold}{The effect size threshold for posterior computation (default = 0.05).}

\item{FutThreshold}{The minimum posterior probability threshold for non-futility (default = 0.8).}

\item{continuous_covariates}{A character vector specifying the names of continuous covariates.}

\item{categorical_covariates}{A character vector specifying the names of categorical covariates (converted to factors).}
}
\value{
A \code{data.frame} with columns:
\itemize{
\item \code{Intervention}: Intervention group identifier.
\item \code{Futility}: 1 if considered futile (posterior probability < FutThreshold), 0 otherwise.
\item \code{ProbES}: Bayesian posterior probabilities that the observed effect size is greater than or equal to a pre-specified threshold
}
}
\description{
This function performs a Bayesian futility analysis for each intervention group compared to control,
across cluster randomized trials (CRT), multisite trials (MST) or simple randomized trials (SRT).
}
\details{
The function loops over each intervention, fits the appropriate Bayesian model (\code{crtBayes}, \code{mstBayes}, \code{srtBayes}),
extracts the posterior probability, and determines futility based on the specified probability threshold.
}
\examples{
\donttest{
###Futility analysis of cluster randomized trial###
data(crt4armSimData)
futilityAnalysis(method = "crt", data = crt4armSimData, outcome = "posttest", 
interventions = "interventions", Random = "schools", Nsim = 10000, 
Threshold = 0.05, FutThreshold = 0.8,continuous_covariates = c("pretest"),
categorical_covariates = c("gender", "ethnicity"))

###Futility analysis of multisite trial###
data(mst4armSimData)
futilityAnalysis(method = "mst", data = mst4armSimData, outcome = "posttest",
interventions = "interventions", Random = "schools", Nsim = 10000, 
Threshold = 0.05, FutThreshold = 0.8,continuous_covariates = c("pretest"),
categorical_covariates = c("gender", "ethnicity"))

###Futility analysis of simple randomized trial###
data(srt4armSimData)
futilityAnalysis(method = "srt", data = srt4armSimData, outcome = "posttest",
interventions = "interventions", Nsim = 10000, Threshold = 0.05, FutThreshold = 0.8,
continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"))
}

}
\seealso{
\code{\link[eefAnalytics]{crtBayes}}, \code{\link[eefAnalytics]{mstBayes}}, \code{\link[eefAnalytics]{srtBayes}} functions from the \pkg{eefAnalytics} package
}
