% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqxw.R
\name{eqxw_UK}
\alias{eqxw_UK}
\title{eqxw_UK}
\usage{
eqxw_UK(x, age, male, dim.names = c("mo", "sc", "ua", "pd", "ad"), bwidth = 0)
}
\arguments{
\item{x}{A vector of 5-digit EQ-5D-5L states (domain scores) or a summary score.}

\item{age}{A numeric vector or column name (if `x` is a data frame). Can be either:
(1) a numeric age between 18 and 100, which will be automatically grouped into NICE-defined age bands (18-35, 35-45, 45-55, 55-65, +65), or
(2) a factor/character/numeric vector already representing the NICE age bands with values 1-5 indicating age bands (18-35, 35-45, 45-55, 55-65, +65).}

\item{male}{A numeric vector (1=male, 0=female) or column name indicating gender.}

\item{dim.names}{A vector of dimension names for EQ-5D states (default: c("mo", "sc", "ua", "pd", "ad")).}

\item{bwidth}{Numeric. Bandwidth for kernel smoothing when using summary scores.}
}
\value{
A vector or data frame with crosswalked EQ-5D-3L utilities.
}
\description{
Crosswalks EQ-5D-5L responses to EQ-5D-3L utilities using NICE's mapping.
}
\examples{
eqxw_UK(c(11111, 12345, 32423, 55555), age = c(30, 40, 55, 70), male = c(1, 0, 1, 0))
}
