% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{ctriple-ergmTerm}
\alias{ctriple-ergmTerm}
\alias{InitErgmTerm.ctriple}
\alias{InitErgmTerm.ctriad}
\alias{ctriad-ergmTerm}
\title{Cyclic triples}
\usage{
# binary: ctriple(attr=NULL, diff=FALSE, levels=NULL)

# binary: ctriad
}
\arguments{
\item{attr, diff}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.) If \code{attr} is specified and \code{diff} is \code{FALSE} , then the statistic is the number of cyclic triples where all
three nodes have the same value of the attribute. If \code{attr} is specified and \code{diff} is \code{TRUE} , then one statistic is added to the model for each value of \code{attr}, equal to the number of cyclic triples where all
three nodes have that value of the attribute.}

\item{levels}{specifies the value of \code{attr} to consider if \code{attr} is passed and \code{diff=TRUE}. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
By default, this term adds one
statistic to the model, equal to the number of cyclic triples in the
network, defined as a set of edges of the form \eqn{\{(i{\rightarrow}j), (j{\rightarrow}k), (k{\rightarrow}i)\}}{\{(i,j), (j,k), (k,i)\}} .
}
\note{
This term can only be used with directed networks.

for all directed networks, \code{triangle} is equal to
\code{ttriple+ctriple} , so at most two of these three terms can be in a
model.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "ctriple", "subsection")}
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{triad-related}
