% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-package.R
\docType{package}
\name{ergm-package}
\alias{ergm-package}
\title{ergm: Fit, Simulate and Diagnose Exponential-Family Models for Networks}
\description{
An integrated set of tools to analyze and simulate networks based on exponential-family random graph models (ERGMs). 'ergm' is a part of the Statnet suite of packages for network analysis. See Hunter, Handcock, Butts, Goodreau, and Morris (2008) \doi{10.18637/jss.v024.i03} and Krivitsky, Hunter, Morris, and Klumb (2023) \doi{10.18637/jss.v105.i06}.
}
\details{
\insertNoCite{HuHa08e,KrHu23e}{ergm}

For a complete list of the functions, use \code{library(help="ergm")} or
read the rest of the manual. For a simple demonstration, use
\code{demo(packages="ergm")}.

When publishing results obtained using this package, please cite the
original authors as described in \code{citation(package="ergm")}.

All programs derived from this package must cite it. Please see the
file \code{LICENSE} and \url{https://statnet.org/attribution}.

Recent advances in the statistical modeling of random networks have had an
impact on the empirical study of social networks. Statistical exponential
family models \insertCite{StIk90p;textual}{ergm} are a generalization of the Markov
random network models introduced by \insertCite{FrSt86m;textual}{ergm}, which in turn
derived from developments in spatial statistics \insertCite{Be74s;textual}{ergm}. These models
recognize the complex dependencies within relational data structures.  To
date, the use of stochastic network models for networks has been limited by
three interrelated factors: the complexity of realistic models, the lack of
simulation tools for inference and validation, and a poor understanding of
the inferential properties of nontrivial models.

This manual introduces software tools for the representation, visualization,
and analysis of network data that address each of these previous
shortcomings.  The package relies on the \code{\link[network:network]{network}}
package which allows networks to be represented in . The
\CRANpkg{ergm} package implements maximum likelihood
estimates of ERGMs to be calculated using Markov Chain Monte Carlo (via
\code{\link[=ergm]{ergm()}}). The package also provides tools for simulating networks
(via \code{\link[=simulate.ergm]{simulate.ergm()}}) and assessing model goodness-of-fit (see
\code{\link[=mcmc.diagnostics]{mcmc.diagnostics()}} and \code{\link[=gof.ergm]{gof.ergm()}}).

A number of Statnet Project packages extend and enhance
\CRANpkg{ergm}. These include
\CRANpkg{tergm} (Temporal ERGM), which provides
extensions for modeling evolution of networks over time;
\CRANpkg{ergm.count}, which facilitates
exponential family modeling for networks whose dyadic measurements are
counts; and
\pkg{ergm.userterms}, available on GitHub at \url{https://github.com/statnet/ergm.userterms}, which
allows users to implement their own ERGM terms.

For detailed information on how to download and install the software, go to
the \CRANpkg{ergm} website: \url{https://statnet.org}. A
tutorial, support newsgroup, references and links to further resources are
provided there.

\insertNoCite{AdHa07n,BeMo08p,BoHu03s,Bu08sna,Bu08net,GoHa08s,GoKi09b,Ha03a,Ha03deg,HaHu08s,HuHa06i,KrHa08l,Kr12e,MoHa08s,StIk90p}{ergm}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ergmTerm}}, \code{\link{ergmConstraint}}, \code{\link{ergmReference}},
\code{\link{ergmHint}}, and \code{\link{ergmProposal}} for indices of model
specification and estimation components visible to the \CRANpkg{ergm}'s API at any given time.
}
\author{
\strong{Maintainer}: Pavel N. Krivitsky \email{pavel@statnet.org} (\href{https://orcid.org/0000-0002-9101-3362}{ORCID})

Authors:
\itemize{
  \item Mark S. Handcock \email{handcock@stat.ucla.edu}
  \item David R. Hunter \email{dhunter@stat.psu.edu}
  \item Carter T. Butts \email{buttsc@uci.edu}
  \item Steven M. Goodreau \email{goodreau@u.washington.edu}
  \item Martina Morris \email{morrism@u.washington.edu}
}

Other contributors:
\itemize{
  \item Li Wang \email{lxwang@gmail.com} [contributor]
  \item Kirk Li \email{kirkli@u.washington.edu} [contributor]
  \item Skye Bender-deMoll \email{skyebend@u.washington.edu} [contributor]
  \item Chad Klumb \email{cklumb@gmail.com} [contributor]
  \item Michał Bojanowski \email{michal2992@gmail.com} (\href{https://orcid.org/0000-0001-7503-852X}{ORCID}) [contributor]
  \item Ben Bolker \email{bbolker+lme4@gmail.com} [contributor]
  \item Christian Schmid \email{songhyo86@gmail.com} [contributor]
  \item Joyce Cheng \email{joyce.cheng@student.unsw.edu.au} [contributor]
  \item Arya Karami \email{a.karami@unsw.edu.au} [contributor]
  \item Adrien Le Guillou \email{git@aleguillou.org} (\href{https://orcid.org/0000-0002-4791-418X}{ORCID}) [contributor]
}

}
\keyword{models}
