% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{benchmarkito}
\alias{benchmarkito}
\title{Utility to benchmark expression in R}
\usage{
benchmarkito(..., times = 100, rand_ord = TRUE)
}
\arguments{
\item{...}{List of expressions to benchmark.}

\item{times}{Integer scalar. Number of replicates.}

\item{rand_ord}{Logical. When \code{TRUE}, the expressions are executed in a random
order.}
}
\value{
A data frame of class \code{ergmito_benchmark} with \code{times} rows and the
following columns:
\itemize{
\item \code{id} Integer. Id of the expression.
\item \code{expr} Factor. Expression executed.
\item \code{user.self}, \code{sys.self}, \code{elapsed}, \code{sys.child} time in seconds (see \code{\link[=proc.time]{proc.time()}}).
}

Includes the following attributes: \code{ncalls}, \code{call}, \code{label}, and \code{expr}.
}
\description{
This is just an internal utility included in the package which is not designed
to be accurate. If you need accurate benchmarks, you should take a look at the
\CRANpkg{microbenchmark} and \CRANpkg{bench} R packages.
}
\details{
The print method prints a summary including quantiles, relative elapsed times,
and the order (fastest to slowest).
}
\examples{
bm <- benchmarkito(
  exp(1:100000),
  sqrt(1:100000),
  times = 20
)

plot(bm)
print(bm)

}
