% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_variants.R
\name{get_erviss_variants}
\alias{get_erviss_variants}
\title{Get ERVISS variants data}
\usage{
get_erviss_variants(
  csv_file = NULL,
  date_min,
  date_max,
  variant = "",
  countries = "",
  min_value = 0,
  indicator = "",
  use_snapshot = FALSE,
  snapshot_date = NULL
)
}
\arguments{
\item{csv_file}{Path to a local CSV file or URL containing the ERVISS data.
If NULL (default), data is fetched from the official ERVISS repository.}

\item{date_min}{Start date of the period (Date object)}

\item{date_max}{End date of the period (Date object)}

\item{variant}{Character vector of variant names to filter.
Use "" (default) to include all variants.}

\item{countries}{Character vector of country names to filter.
Use "" (default) to include all countries.}

\item{min_value}{Minimum value threshold to include in the results (default: 0)}

\item{indicator}{Type of indicator: "proportion" or "detections".
Use "" (default) to include all indicators.}

\item{use_snapshot}{Logical. If TRUE, fetches a historical snapshot; if FALSE (default),
fetches the latest data. Ignored if csv_file is provided.}

\item{snapshot_date}{Date of the snapshot to retrieve.
Required if use_snapshot = TRUE and csv_file is NULL.}
}
\value{
A data.table containing the filtered variant data with columns:
date, value, variant, countryname, indicator, and other ERVISS fields.
}
\description{
Retrieves and filters SARS-CoV-2 variant data from the ERVISS (European Respiratory
Virus Surveillance Summary) for a specified date range, variant(s), and country(ies).
}
\examples{
\donttest{
# Get latest variant data for France
data <- get_erviss_variants(
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-12-31"),
  countries = "France"
)

# Get specific variants with minimum proportion threshold
data <- get_erviss_variants(
  date_min = as.Date("2024-06-01"),
  date_max = as.Date("2024-12-31"),
  variant = c("XFG", "LP.8.1"),
  min_value = 5
)
}
}
