% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_generic.R
\name{quick_plot_erviss_data}
\alias{quick_plot_erviss_data}
\title{Quick plot of ERVISS data}
\usage{
quick_plot_erviss_data(
  type = ERVISS_TYPES,
  csv_file = NULL,
  date_min,
  date_max,
  pathogen = "",
  variant = "",
  indicator = "",
  age = "",
  countries = "",
  min_value = 0,
  date_breaks = NULL,
  date_format = "\%b \%Y",
  use_snapshot = FALSE,
  snapshot_date = NULL
)
}
\arguments{
\item{type}{Type of data. One of: "positivity", "variants", "ili_ari_rates",
"sari_rates", "sari_positivity", "nonsentinel_severity", "nonsentinel_tests".}

\item{csv_file}{Path to a local CSV file or URL containing the ERVISS data.
If NULL (default), data is fetched from the official ERVISS repository.}

\item{date_min}{Start date of the period (Date object)}

\item{date_max}{End date of the period (Date object)}

\item{pathogen}{Character vector of pathogen names to filter. Used for types:
"positivity", "sari_positivity", "nonsentinel_severity", "nonsentinel_tests".
Use "" (default) to include all pathogens.}

\item{variant}{Character vector of variant names to filter. Only used for
type = "variants". Use "" (default) to include all variants.}

\item{indicator}{Character vector of indicators to filter. The available values
depend on the data type. Use "" (default) to include all indicators.}

\item{age}{Character vector of age groups to filter. Used for types:
"ili_ari_rates", "sari_rates", "sari_positivity", "nonsentinel_severity",
"nonsentinel_tests". Use "" (default) to include all age groups.}

\item{countries}{Character vector of country names to filter.
Use "" (default) to include all countries.}

\item{min_value}{Minimum value threshold (default: 0).
Only used for type = "variants".}

\item{date_breaks}{A string specifying the date breaks for the x-axis
(e.g., "1 month", "2 weeks"). If NULL, a sensible default is chosen based
on the data type.}

\item{date_format}{A string specifying the date format for x-axis labels
(e.g., \code{"\%b \%Y"} for "Jan 2024")}

\item{use_snapshot}{Logical. If TRUE, fetches a historical snapshot; if FALSE (default),
fetches the latest data. Ignored if csv_file is provided.}

\item{snapshot_date}{Date of the snapshot to retrieve.
Required if use_snapshot = TRUE and csv_file is NULL.}
}
\value{
A ggplot2 object showing the data over time by country
}
\description{
Convenience function that fetches and plots ERVISS data in one step.
This is a generic function that can handle any of the available data types.
For more control, use \code{\link{get_erviss_data}} followed by
\code{\link{plot_erviss_data}}.
}
\examples{
\donttest{
# Quick visualization of positivity data
quick_plot_erviss_data(
  type = "positivity",
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-12-31"),
  pathogen = "SARS-CoV-2"
)

# Quick visualization of ILI rates
quick_plot_erviss_data(
  type = "ili_ari_rates",
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-12-31"),
  indicator = "ILIconsultationrate"
)
}
}
