% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_variants.R
\name{quick_plot_erviss_variants}
\alias{quick_plot_erviss_variants}
\title{Quick plot of ERVISS variants data}
\usage{
quick_plot_erviss_variants(
  csv_file = NULL,
  date_min,
  date_max,
  variant = "",
  countries = "",
  min_value = 0,
  indicator = "",
  date_breaks = "1 month",
  date_format = "\%b \%Y",
  use_snapshot = FALSE,
  snapshot_date = NULL
)
}
\arguments{
\item{csv_file}{Path to a local CSV file or URL containing the ERVISS data.
If NULL (default), data is fetched from the official ERVISS repository.}

\item{date_min}{Start date of the period (Date object)}

\item{date_max}{End date of the period (Date object)}

\item{variant}{Character vector of variant names to filter.
Use "" (default) to include all variants.}

\item{countries}{Character vector of country names to filter.
Use "" (default) to include all countries.}

\item{min_value}{Minimum value threshold to include in the results (default: 0)}

\item{indicator}{Type of indicator: "proportion" or "detections".
Use "" (default) to include all indicators.}

\item{date_breaks}{A string specifying the date breaks for the x-axis
(e.g., "1 month", "2 weeks")}

\item{date_format}{A string specifying the date format for x-axis labels
(e.g., \code{"\%b \%Y"} for "Jan 2024")}

\item{use_snapshot}{Logical. If TRUE, fetches a historical snapshot; if FALSE (default),
fetches the latest data. Ignored if csv_file is provided.}

\item{snapshot_date}{Date of the snapshot to retrieve.
Required if use_snapshot = TRUE and csv_file is NULL.}
}
\value{
A ggplot2 object showing variant proportions over time by country
}
\description{
Convenience function that fetches and plots ERVISS variant data in one step.
For more control, use \code{\link{get_erviss_variants}} followed by
\code{\link{plot_erviss_variants}}.
}
\examples{
\donttest{
# Quick visualization of latest variant data
quick_plot_erviss_variants(
  date_min = as.Date("2024-06-01"),
  date_max = as.Date("2024-12-31"),
  variant = c("XFG", "LP.8.1"),
  date_breaks = "1 month"
)
}
}
