% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtpi2_selector.R
\name{get_mtpi2}
\alias{get_mtpi2}
\title{Get an object to fit the mTPI-2 dose-finding model.}
\usage{
get_mtpi2(
  parent_selector_factory = NULL,
  num_doses,
  target,
  epsilon1,
  epsilon2,
  exclusion_certainty,
  alpha = 1,
  beta = 1,
  stop_when_deescalation_impossible = FALSE,
  ...
)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{num_doses}{Number of doses under investigation.}

\item{target}{We seek a dose with this probability of toxicity.}

\item{epsilon1}{This parameter determines the lower bound of the
equivalence interval. See Details.}

\item{epsilon2}{This parameter determines the upper bound of the
equivalence interval. See Details.}

\item{exclusion_certainty}{Numeric, threshold posterior certainty required to
exclude a dose for being excessively toxic. The authors discuss values in the
range 0.7 - 0.95. Set to a value > 1 to suppress the dose exclusion
mechanism. The authors use the Greek letter xi for this parameter.}

\item{alpha}{First shape parameter of the beta prior distribution on the
probability of toxicity.}

\item{beta}{Second shape parameter of the beta prior distribution on the
probability of toxicity.}

\item{stop_when_deescalation_impossible}{TRUE to stop a trial and recommend
no dose when the advice is to de-escalate but de-escalation is impossible
because we are already at the lowest dose. Note that this feature was
requested by a user. This param is FALSE by default so that behaviour matches
what was described in the publication. The original authors do advocate this
behaviour.}

\item{...}{Extra args are passed onwards.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
mTPI-2 model to outcomes.
}
\description{
The modified toxicity probability interval 2 (mTPI-2) is a dose-escalation
design by Guo et al. As the name suggests, it is an adaptation of the mTPI
design.
}
\section{Details}{

The design seeks a dose with probability of toxicity \eqn{p_{i}}
close to a target probability \eqn{p_{T}} by iteratively calculating the
interval \deqn{p_{T} - \epsilon_{1} < p_{i} < p_{T} + \epsilon_{2}}
In this model, \eqn{\epsilon_{1}} and \eqn{\epsilon_{2}} are specified
constants. \eqn{p_{i}} is estimated by a Bayesian beta-binomial conjugate
model \deqn{p_{i} | data \sim Beta(\alpha + x_{1}, \beta + n_{i} - x_{i}),}
where \eqn{x_{i}} is the number of toxicities observed and \eqn{n_{i}} is the
number of patients treated at dose \eqn{i}, and \eqn{\alpha} and \eqn{\beta}
are hyperparameters for the beta prior on \eqn{p_{i}}.
A dose is excluded as inadmissible if
\deqn{P(p_{i} > p_{T} | data) > \xi}
The trial commences at a starting dose, possibly dose 1. If dose \eqn{i}
has just been evaluated in patient(s), dose selection decisions proceed by
calculating the unit probability mass of the true toxicity rate at dose
\eqn{i} using the partition of the probability space into subintervals with
equal length given by\eqn{(\epsilon_{1} + \epsilon_{2})}. \eqn{EI} is the
equivalence interval \eqn{p_{T} - epsilon_{1}, p_{T} - epsilon_{2}}, with
\eqn{LI} the set of all intervals below, and \eqn{HI} the set of all
intervals above.
The unit probability mass (UPM) of an interval is the posterior probability
that the true toxicity rate belongs to the interval divided by the width of
the interval. The interval with maximal UPM determines the recommendation for
the next patient(s), with the intervals corresponding to decisions to
escalate, stay, and de-escalate dose, respectively. Further to this are rules
that prevent escalation to an inadmissible dose.
In the original mTPI paper, the authors demonstrate acceptable operating
performance using \eqn{\alpha = \beta = 1}, \eqn{K_{1} = 1},
\eqn{K_{2} = 1.5} and  \eqn{\xi = 0.95}.
The authors of the mTPI-2 approach show desirable performance as compared
to the original mTPI method, under particular parameter choices.
See the publications for full details.
}

\examples{
target <- 0.25
model1 <- get_mtpi2(num_doses = 5, target = target, epsilon1 = 0.05,
  epsilon2 = 0.05, exclusion_certainty = 0.95)

outcomes <- '1NNN 2NTN'
model1 \%>\% fit(outcomes) \%>\% recommended_dose()

}
\references{
Ji, Y., Liu, P., Li, Y., & Bekele, B. N. (2010).
 A modified toxicity probability interval method for dose-finding trials.
 Clinical Trials, 7(6), 653–663. https://doi.org/10.1177/1740774510382799

Ji, Y., & Yang, S. (2017).
On the Interval-Based Dose-Finding Designs, 1–26.
Retrieved from https://arxiv.org/abs/1706.03277

Guo, W., Wang, SJ., Yang, S., Lynn, H., Ji, Y. (2017).
A Bayesian Interval Dose-Finding Design Addressing Ockham's Razor: mTPI-2.
https://doi.org/10.1016/j.cct.2017.04.006
}
