% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_meta.R
\name{plot_meta}
\alias{plot_meta}
\title{Generates a forest plot displaying results of a meta-analysis}
\usage{
plot_meta(
  estimate,
  mark_zero = TRUE,
  include_PIs = FALSE,
  report_CIs = FALSE,
  explain_DR = FALSE,
  meta_diamond_height = 0.35,
  ggtheme = ggplot2::theme_classic()
)
}
\arguments{
\item{estimate}{\itemize{
\item an esci_estimate object generated by an esci meta_ function
}}

\item{mark_zero}{\itemize{
\item Boolean; defaults to TRUE to include a dotted line
indicated no effect (effect_size = 0)
}}

\item{include_PIs}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE to include
prediction intervals for the overall effect and each moderator level (if
defined)
}}

\item{report_CIs}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE to include
printed representation of each study effect size and CI along the right-
hand of the figure
}}

\item{explain_DR}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE if no moderator
is defined to show both the RE and FE effect sizes to represent how the
diamond ration measure of effect-size heterogeneity is calculated
}}

\item{meta_diamond_height}{\itemize{
\item Optional real number > 0 to indicate height that
each meta-analytic diamond should be drawn; defaults to 0.35
}}

\item{ggtheme}{\itemize{
\item Optional ggplot2 theme object to control overall styling;
defaults to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}
}}
}
\value{
Returns a ggplot object
}
\description{
`plot_meta' returns a ggplot2 object visualizing the results of
a meta-analysis, showing each study effect size and CI, the overall effect
size and CI as a diamond, effect sizes estimated at each moderator level
(if defined), and (optionally) prediction intervals for subsequent studies.
This function requires as input an esci_estimate object generated by an
esci meta-analysis function: \code{\link[=meta_any]{meta_any()}}, \code{\link[=meta_d1]{meta_d1()}},
\code{\link[=meta_d2]{meta_d2()}}, \code{\link[=meta_mdiff_two]{meta_mdiff_two()}}, \code{\link[=meta_mean]{meta_mean()}},
\code{\link[=meta_pdiff_two]{meta_pdiff_two()}}, \code{\link[=meta_proportion]{meta_proportion()}}, and \code{\link[=meta_r]{meta_r()}}.
}
\details{
This function was developed primarily for student use within jamovi when
learning along with the text book Introduction to the New Statistics, 2nd
edition (Cumming & Calin-Jageman, 2024).

Expect breaking changes as this function is improved for general use.  Work
still do be done includes:
\itemize{
\item Revise to avoid deprecated ggplot features
\item Revise for consistent ability to control aesthetics and consistent
layer names
}
}
\examples{
# Data set -- see Introduction to the New Statistics, 2nd edition
data("data_mccabemichael_brain")

# Meta-analysis: random effects, no moderator
estimate <- esci::meta_mdiff_two(
  data = esci::data_mccabemichael_brain,
  comparison_means = "M Brain",
  comparison_sds = "s Brain",
  comparison_ns = "n Brain",
  reference_means = "M No Brain",
  reference_sds = "s No Brain",
  reference_ns = "n No Brain",
  labels = "Study name",
  effect_label = "Brain Photo Rating - No Brain Photo Rating",
  assume_equal_variance = TRUE,
  random_effects = TRUE
)
# Forest plot
myplot_forest <- esci::plot_meta(estimate)


# Meta-analysis: random effects, moderator
estimate_moderator <- esci::meta_mdiff_two(
  data = esci::data_mccabemichael_brain,
  comparison_means = "M Brain",
  comparison_sds = "s Brain",
  comparison_ns = "n Brain",
  reference_means = "M No Brain",
  reference_sds = "s No Brain",
  reference_ns = "n No Brain",
  labels = "Study name",
  moderator = "Research group",
  effect_label = "Brain Photo Rating - No Brain Photo Rating",
  assume_equal_variance = TRUE,
  random_effects = TRUE
)
# Forest plot
myplot_forest_moderator <- esci::plot_meta(estimate_moderator)


# Meta-analysis: random effects, moderator, output d_s
estimate_moderator_d <- esci::meta_mdiff_two(
  data = esci::data_mccabemichael_brain,
  comparison_means = "M Brain",
  comparison_sds = "s Brain",
  comparison_ns = "n Brain",
  reference_means = "M No Brain",
  reference_sds = "s No Brain",
  reference_ns = "n No Brain",
  labels = "Study name",
  moderator = "Research group",
  effect_label = "Brain Photo Rating - No Brain Photo Rating",
  assume_equal_variance = TRUE,
  random_effects = TRUE
)
# Forest plot
myplot_forest_moderator_d <- esci::plot_meta(estimate_moderator_d)


}
