% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_merge.R
\name{signal_merge}
\alias{signal_merge}
\title{Merge several signal streams into one}
\usage{
signal_merge(..., fill = FALSE)
}
\arguments{
\item{\dots}{\code{eseis} objects that will be merged into one output
\code{eseis} object. Can also be one list that contains \code{eseis}
objects.}

\item{fill}{\code{Logical} value, option to fill data gaps between 
merged streams. Default is \code{FALSE}.}
}
\value{
\code{eseis} object with merged input data sets
}
\description{
This function merges two or more single signals into one common. Only 
\code{eseis} objects are supported. Gaps will be filled with \code{NA}
values unless the argument \code{fill = TRUE}. The resulting data length
will correspond to the combined length of the input data. The sampling 
frequency must be the same for all input data sets. The meta data of the  
first stream will be used for the output data.
}
\examples{

## load rockfall data set
data("rockfall")
s_1 <- rockfall_eseis

## duplicate data set and shift start time (incl. gap)
s_2 <- s_1
s_2$meta$starttime <- s_2$meta$starttime + 500

## merge data sets
s_merged <- signal_merge(s_1, s_2)

## plot merged data set
plot(s_merged)

## merge and fill gap
s_merged_filled <- signal_merge(s_1, s_2, fill = TRUE)

## plot merged data set
plot(s_merged_filled)

}
\author{
Michael Dietze
}
\keyword{eseis}
