% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_raw_data_loader.R
\name{dicom.raw.data.loader}
\alias{dicom.raw.data.loader}
\title{DICOM file loading in raw data}
\usage{
dicom.raw.data.loader(dcm.filename)
}
\arguments{
\item{dcm.filename}{Character string, representing the full name of a DICOM file.}
}
\value{
Returns a vector of raw data from \code{dcm.filename}.
}
\description{
the \code{dicom.raw.data.loader} function loads a DICOM file as
raw data.
}
\examples{
# First, save toy.dicom.raw () raw data to a temporary file for testing.
pat.src.dir <- file.path (tempdir(), "toy_dcm")
dir.create (pat.src.dir, recursive = TRUE) 
dcm.filename <- tempfile (pattern = "toyrtplan", tmpdir = pat.src.dir,
                          fileext = ".dcm")
zz <- file (dcm.filename, "wb")
writeBin (toy.dicom.raw (), zz, size = 1)
close (zz)

# loading of file
dicom.raw.data <- dicom.raw.data.loader (dcm.filename)

# checks if it is consistent with the original raw data
all ( dicom.raw.data == toy.dicom.raw () )

# Cleaning  temporary directory
unlink (pat.src.dir, recursive = TRUE)
}
\seealso{
\link[espadon]{dicom.browser}, \link[espadon]{dicom.tag.parser}
}
