% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.diferencia.medias.R
\name{ic.diferencia.medias}
\alias{ic.diferencia.medias}
\title{Intervalo confianza para la diferencia de medias.}
\usage{
ic.diferencia.medias(
  x,
  variable = NULL,
  introducir = FALSE,
  poblacion = c("normal", "desconocida"),
  var_pob = c("conocida", "desconocida"),
  iguales = FALSE,
  confianza = 0.95
)
}
\arguments{
\item{x}{Conjunto de datos. Puede ser un vector o un dataframe.}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} se refiere a dos variables, \code{variable = NULL}. En caso contrario, es necesario indicar el nombre o posición (número de columna) de las variables.}

\item{introducir}{Valor lógico. Si \code{introducir = FALSE} (por defecto), el usuario debe indicar el conjunto de datos que desea analizar usando los argumentos \code{x} y/o \code{variable}. Si \code{introducir = TRUE}, se le solicitará al ususario que introduzca la información relevante sobre tamaño muestral, valor de la media muestral, etc.}

\item{poblacion}{Es un carácter. Indica la distribución de probabilidad de la población. Por defecto \code{poblacion = "normal"}. Si la distribución de la población es desconocida, cambiar a \code{poblacion = "desconocida"}.}

\item{var_pob}{Es un carácter. Indica si la varianza poblacional es conocida (por defecto, \code{var_pob = "conocida"}) o desconocida. En este último caso debería cambiarse el argumento a \code{var_pob = "desconocida"}.}

\item{iguales}{Por defecto se considera que las varianzas poblacionales son distintas (\code{iguales = FALSE}). En el supuesto de varianzas poblacionales iguales cambiar el argumento a \code{iguales = TRUE}.}

\item{confianza}{Es un valor numérico entre 0 y 1. Indica el nivel de confianza. Por defecto, \code{confianza = 0.95} (95 por ciento)}
}
\value{
Devuelve el intervalo de confianza de la diferencia de medias poblacionales en un objeto de tipo \code{data.frame}.
}
\description{
Calcula el intervalo de confianza de la diferencia de medias poblacionales.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qricdiferenciamedias.png}{width = 200px}}
\if{latex}{\figure{qricdiferenciamedias.png}{options: width=3cm}}
}
\details{
Se obtienen los intervalos según los siguientes casos:

Caso 1: Varianzas poblacionales conocidas

\if{html}{\figure{icdifmedias1.png}{width = 60px}}
\if{latex}{\figure{icdifmedias1.png}{options: width=10cm}}

Nota: Si los tamaños muestrales nx y ny son suficientemente grandes, pueden estimarse las varianzas poblacionales
por sus correspondientes varianzas (o cuasivarianzas), incluso aunque las distribuciones poblacionales no sean normales
(por aplicación del TCL).

Caso 2. Varianzas poblacionales desconocidas pero iguales

(2.1) con varianza muestral:

\if{html}{\figure{icdifmedias2.png}{width = 560px}}
\if{latex}{\figure{icdifmedias2.png}{options: width=10cm}}

(2.2) con cuasivarianza muestral:

\if{html}{\figure{icdifmedias2cuasi.png}{width = 600px}}
\if{latex}{\figure{icdifmedias2cuasi.png}{options: width=10cm}}

Nota: Tanto en el caso (2.1) como (2.2) la distribución t tiene (nx+ny-2) grados de libertad.

Caso 3. Varianzas poblacionales desconocidas y distintas

(3.1) con varianza muestral:

\if{html}{\figure{icdifmedias3.png}{width = 480px}}
\if{latex}{\figure{icdifmedias3.png}{options: width=8cm}}

la distribución t con grados de libertad igual al entero más próximo de v.

\if{html}{\figure{icdifmedias3gl.png}{width = 520px}}
\if{latex}{\figure{icdifmedias3gl.png}{options: width=8cm}}

(3.2) con cuasivarianza muestral:

\if{html}{\figure{icdifmedias3cuasi.png}{width = 480px}}
\if{latex}{\figure{icdifmedias3cuasi.png}{options: width=7cm}}

la distribución t con grados de libertad igual a v, donde v = (parte entera de v*) + 1

\if{html}{\figure{icdifmedias3cuasigl.png}{width = 520px}}
\if{latex}{\figure{icdifmedias3cuasigl.png}{options: width=6cm}}
}
\references{
Casas José M. (1997) Inferencia estadística. Editorial: Centro de estudios Ramón Areces, S.A. ISBN: 848004263-X

Esteban García, J. et al. (2008). Curso básico de inferencia estadística. ReproExprés, SL. ISBN: 8493036595.

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
