% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizBoxWhisker.R
\name{VizBoxWhisker}
\alias{VizBoxWhisker}
\title{Box-And-Whisker Plot of Time Series with Ensemble Distribution}
\usage{
VizBoxWhisker(
  exp,
  obs,
  toptitle = "",
  ytitle = "",
  monini = 1,
  yearini = 0,
  freq = 1,
  expname = "exp 1",
  obsname = "obs 1",
  drawleg = TRUE,
  fileout = NULL,
  width = 8,
  height = 5,
  size_units = "in",
  res = 100,
  ...
)
}
\arguments{
\item{exp}{Forecast array of multi-member time series, e.g., the NAO index 
of one experiment. The expected dimensions are 
c(members, start dates/forecast horizons). A vector with only the time 
dimension can also be provided. Only monthly or lower frequency time 
series are supported. See parameter freq.}

\item{obs}{Observational vector or array of time series, e.g., the NAO index 
of the observations that correspond the forecast data in \code{exp}.
The expected dimensions are c(start dates/forecast horizons) or 
c(1, start dates/forecast horizons). Only monthly or lower frequency time 
series are supported. See parameter freq.}

\item{toptitle}{Character string to be drawn as figure title.}

\item{ytitle}{Character string to be drawn as y-axis title.}

\item{monini}{Number of the month of the first time step, from 1 to 12.}

\item{yearini}{Year of the first time step.}

\item{freq}{Frequency of the provided time series: 1 = yearly, 12 = monthly,}

\item{expname}{Experimental dataset name.}

\item{obsname}{Name of the observational reference dataset.}

\item{drawleg}{TRUE/FALSE: whether to draw the legend or not.}

\item{fileout}{Name of output file. Extensions allowed: eps/ps, jpeg, png, 
pdf, bmp and tiff. \cr
Default = 'output_PlotBox.ps'.}

\item{width}{File width, in the units specified in the parameter size_units 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{size_units}{Units of the size of the device (file or window) to plot 
in. Inches ('in') by default. See ?Devices and the creator function of the 
corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{...}{Arguments to be passed to the method. Only accepts the following
graphical parameters:\cr
ann ask bg cex.lab cex.sub cin col.axis col.lab col.main col.sub cra crt 
csi cxy err family fg fig font font.axis font.lab font.main font.sub lend 
lheight ljoin lmitre mex mfcol mfrow mfg mkh oma omd omi page pin plt pty 
smo srt tck tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog \cr
For more information about the parameters see `par`.}
}
\value{
A figure in popup window by default, or saved to the specified path
via \code{fileout}.
}
\description{
Produce time series of box-and-whisker plot showing the distribution of the 
members of a forecast vs. the observed evolution. The correlation between
forecast and observational data is calculated and displayed. Only works for 
n-monthly to n-yearly time series.
}
\examples{
# No example data is available over NAO region, so in this example we will
# tweak the longitude and latitude.
ano <- s2dv::Ano_CrossValid(map_temp$exp, map_temp$obs, memb = FALSE,
                            dat_dim = c('dat', 'member'), memb_dim = 'member')
nao <- s2dv::NAO(ano$exp, ano$obs, lat = seq(20, 80, length.out = 11),
                 lon = seq(-80, 40, length.out = 16), memb_dim = "member",
                 ftime_dim = "time")
nao$exp <- drop(aperm(nao$exp, c(2, 1, 3, 4)))
nao$obs <- drop(nao$obs)
VizBoxWhisker(nao$exp, nao$obs, toptitle = "NAO index", 
              ytitle = "NAO index (PC1) TOS", monini = 11, freq = 1,
              yearini = 2000, expname = "SEAS5", obsname = "ERA5")

}
\seealso{
EOF, ProjectField, NAO
}
