% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etree-methods.R
\name{etree-methods}
\alias{etree-methods}
\alias{print.etree}
\alias{length.etree}
\alias{depth.etree}
\alias{width.etree}
\alias{"[.etree"}
\alias{"[[.etree"}
\alias{length.party}
\alias{depth.party}
\alias{width.party}
\alias{[.etree}
\alias{[[.etree}
\title{Methods for "etree" objects}
\usage{
\method{print}{etree}(
  x,
  FUN = NULL,
  digits = getOption("digits") - 4,
  header = NULL,
  footer = TRUE,
  ...
)

\method{length}{etree}(x)

\method{depth}{etree}(x, root = FALSE, ...)

\method{width}{etree}(x, ...)

\method{[}{etree}(x, i, \dots)

\method{[[}{etree}(x, i, \dots)
}
\arguments{
\item{x}{Object of class \code{"etree"}.}

\item{FUN}{Function to be applied to nodes.}

\item{digits}{Number of digits to be printed.}

\item{header}{Header to be printed.}

\item{footer}{Footer to be printed.}

\item{...}{Additional arguments.}

\item{root}{Logical indicating whether the root node should be counted in
\code{depth()} or not (default).}

\item{i}{Integer specifying the root of the subtree to extract.}
}
\value{
The \code{print()} method generates a textual representation of the tree.
\code{length()} returns the number of nodes in the tree, \code{depth()} the
depth of the tree and \code{width()} the number of terminal nodes. The subset
methods extract subtrees starting from a given node.
}
\description{
Methods for objects of class \code{"etree"}.
}
\section{Functions}{
\itemize{
\item \code{print.etree}: Generates textual representation of the tree.

\item \code{length.party}: Number of nodes in the tree.

\item \code{depth.party}: Depth of the three.

\item \code{width.party}: Number of terminal nodes.

\item \code{[.etree}: Extract subtrees.

\item \code{[[.etree}: Extract subtrees.
}}

\examples{

\donttest{

## Covariates
nobs <- 100
cov_num <- rnorm(nobs)
cov_nom <- factor(rbinom(nobs, size = 1, prob = 0.5))
cov_gph <- lapply(1:nobs, function(j) igraph::sample_gnp(100, 0.2))
cov_fun <- fda.usc::rproc2fdata(nobs, seq(0, 1, len = 100), sigma = 1)
cov_list <- list(cov_num, cov_nom, cov_gph, cov_fun)

## Response variable
resp_reg <- cov_num ^ 2

## Fit
etree_fit <- etree(response = resp_reg, covariates = cov_list)

## Print
print(etree_fit)

## Number of nodes in the tree
length(etree_fit)

## Depth of the tree
depth(etree_fit)

## Number of terminal nodes in the tree
width(etree_fit)

## Extract subtrees
etree_fit[2]
etree_fit[[2]]

}

}
