% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eforest.R
\name{predict.eforest}
\alias{predict.eforest}
\title{Predictions for Energy Forests}
\usage{
\method{predict}{eforest}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{A fitted Energy Forest of class \code{"eforest"}.}

\item{newdata}{Optional set of new covariates used to make predictions. Must
be provided as a list, where each element is a different variable.
Currently available types and the form they need to have to be correctly
recognized are the following:
\itemize{
\item Numeric: numeric or integer vectors;
\item Nominal: factors;
\item Functions: objects of class \code{"fdata"};
\item Graphs: (lists of) objects of class \code{"igraph"}.
}
Each element (i.e., variable) in the covariates list must have the same
\code{length()}, which corresponds to the (new) sample size. If
\code{newdata} is omitted, fitted values of individual trees are somehow
combined (see Details) and returned.}

\item{...}{Additional arguments.}
}
\value{
Predictions, in the form of a factor for classification or as a numeric
vector for regression.
}
\description{
Compute predictions for objects of class \code{"eforest"} (i.e., as returned
by \code{\link[etree:eforest]{eforest()}}).
}
\details{
The \code{predict()} method for \code{"eforest"} objects computes predictions
for Energy Forests as returned by \code{\link[etree:eforest]{eforest()}}.
Predictions are based either on the fitted values (if \code{newdata} is
\code{NULL}) or on the new set of covariates (when \code{newdata} is
provided). In both cases, each tree in \code{object$ensemble} is used to make
predictions by calling \code{\link[etree:predict.etree]{predict()}} on it
(with the same specification of \code{newdata}). Then, individual trees'
predictions for any single observation are combined by majority voting rule
for classification or by arithmetic mean for regression.
}
