% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sample_size_vectorised.R
\name{compute_sample_size_vectorised}
\alias{compute_sample_size_vectorised}
\title{Compute sample size for freedom from disease (vectorised)}
\usage{
compute_sample_size_vectorised(N, prev, accuracy)
}
\arguments{
\item{N}{Integer vector containing the population sizes}

\item{prev}{Numeric between 0 and 1; design prevalence}

\item{accuracy}{Numeric between 0 and 1; accuracy of the survey (i.e.
detection probability)}
}
\value{
Sample size (integer vector).
}
\description{
Compute sample size for a one stage freedom from disease survey for given
Population size, design prevalence and accuracy, assuming a perfect
diagnostic test. Vectorised version of \code{\link{compute_sample_size}}.
}
\details{
Uses vapply to vectorise \code{\link{compute_sample_size}} over the
population size \code{N}. \code{prev} and \code{accuracy} must be scalars.
For the sake of efficiency, the sample size is only computed once for every
different value of \code{N}, even if they apper multiple times in the vector.
}
\seealso{
\code{\link{compute_sample_size}}
}
\author{
Ian Kopacka
}
