% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{importDimLabel}
\alias{importDimLabel}
\title{Import Eurostat label (description) of a given dimension code}
\usage{
importDimLabel(EurostatDimCode)
}
\arguments{
\item{EurostatDimCode}{A string -- the code name of the Eurostat dimension, e.g. \code{"geo"} or \code{"nace_r2"}
or \code{"indic_sb"}, etc.}
}
\value{
A character vector of length 1: the label/description of \code{EurostatDimCode}.
}
\description{
Import the appropriate description file
for the selected Eurostat dimension, e.g. for \code{"geo"} it is \code{"Geopolitical entity (reporting)"},
for \code{"nace_r2"} it is \code{"Classification of economic activities - NACE Rev.2"},
for \code{"indic_sb"} it is \code{"Economical indicator for structural business statistics"} etc.
Click on "Code lists" just under "Apply download operations on" at \url{https://ec.europa.eu/eurostat/databrowser/bulk?lang=en}
for the list of all codes.
Each description is imported from inside the XML file
(via the path: \emph{m:Structure / m:Structures / s:Codelists / s:Codelist / c:Name xml:lang="en"})
from the respective URL, e.g. for \code{"geo"} it is
\url{https://ec.europa.eu/eurostat/api/dissemination/sdmx/2.1/codelist/ESTAT/GEO}.
}
\examples{
\dontrun{
importDimLabel('nace_r2')
}
}
