% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_rast.R
\name{wrf_rast}
\alias{wrf_rast}
\title{Creates SpatRaster object from wrf file}
\usage{
wrf_rast(
  file = file.choose(),
  name = NA,
  map,
  level = 1,
  times,
  latlon = FALSE,
  method = "bilinear",
  as_polygons = FALSE,
  flip_h = FALSE,
  flip_v = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{file}{wrf file}

\item{name}{variable name}

\item{map}{(optional) file with lat-lon variables and grid information}

\item{level}{only for 4d data, numeric, default is 1 for surface (include all times)}

\item{times}{only for 4d data, numeric, set to select time instead of levels (include all levels)}

\item{latlon}{logical (default is FALSE), set TRUE project the output to "+proj=longlat +datum=WGS84 +no_defs"}

\item{method}{method passed to terra::projection, default is bilinear}

\item{as_polygons}{logical, true to return a SpatVector instead of SpatRaster}

\item{flip_h}{horizontal flip (by rows)}

\item{flip_v}{vertical flip (by cols)}

\item{verbose}{display additional information}

\item{...}{extra arguments passed to ncdf4::ncvar_get}
}
\value{
SpatRaster object (terra package)
}
\description{
Creates a SpatRaster (terra R-package) object from a variable from wrf file (or another compatible NetCDF)
}
\examples{
{

wrf <- paste(system.file("extdata", package = "eva3dm"),
                         "/wrfinput_d01", sep="")

r <- wrf_rast(file=wrf, name='XLAT')

plot_rast(r)
}
}
